/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge120.gui.screen;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.models.responses.impl.COPPLoginResponse;
import graphics.continuum.forge120.gui.screen.GuiScreen;
import graphics.continuum.forge120.gui.screen.ProductManagerScreen;
import graphics.continuum.forge120.gui.widget.PasswordFieldWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AccountLoginScreen
extends GuiScreen {
    protected EditBox usernameField;
    protected PasswordFieldWidget passwordField;
    private Button loginButton;
    private Thread loginThread;
    private COPPLoginResponse attemptedLoginResponse;
    private boolean errorThrown;
    private String errorMessage;

    public AccountLoginScreen(Screen previousScreen, COPPLoginResponse attemptedLoginResponse) {
        super(previousScreen, (Component)Component.m_237113_((String)"Continuum Account Login"));
        this.attemptedLoginResponse = attemptedLoginResponse;
    }

    @Override
    protected void m_7856_() {
        int offsetY = 50;
        this.usernameField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - offsetY, 200, 20, (Component)Component.m_237113_((String)"text"));
        this.passwordField = new PasswordFieldWidget(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - offsetY + 40, 200, 20, "text");
        this.m_142416_((GuiEventListener)this.usernameField);
        this.m_142416_((GuiEventListener)this.passwordField);
        this.loginButton = Button.m_253074_((Component)Component.m_237113_((String)"Login"), button -> {
            this.errorThrown = false;
            this.loginThread = new Thread(() -> {
                try {
                    this.attemptedLoginResponse = FocalEngineCore.getInstance().attemptLogin(this.usernameField.m_94155_(), this.passwordField.m_94155_());
                    if (!this.attemptedLoginResponse.isSuccess()) {
                        this.loginButton.m_93666_((Component)Component.m_237113_((String)"Login"));
                        this.loginButton.f_93623_ = true;
                    }
                }
                catch (Exception e) {
                    this.errorThrown = true;
                    this.errorMessage = e.getLocalizedMessage();
                    this.loginButton.m_93666_((Component)Component.m_237113_((String)"Login"));
                    this.loginButton.f_93623_ = true;
                    FocalEngineCore.getInstance().getLogger().error("Failed to log " + this.usernameField.m_94155_() + " in: ", (Throwable)e);
                }
            }, "Account Login Thread");
            this.loginButton.m_93666_((Component)Component.m_237113_((String)"Logging In..."));
            this.loginButton.f_93623_ = false;
            this.loginThread.start();
        }).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ - 50).m_253046_(200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.loginButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> {
            if (this.loginThread != null) {
                this.loginThread.interrupt();
            }
            this.returnToPreviousScreen();
        }).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ - 25).m_253046_(200, 20).m_253136_());
    }

    @Override
    public void m_86600_() {
        this.usernameField.m_94120_();
        this.passwordField.m_94120_();
        if (this.loginThread != null && !this.loginThread.isAlive() && this.attemptedLoginResponse != null && this.attemptedLoginResponse.isSuccess()) {
            Screen previous = this.previousScreen;
            if (this.previousScreen instanceof ProductManagerScreen) {
                previous = ((ProductManagerScreen)this.previousScreen).previousScreen;
            }
            Minecraft.m_91087_().m_91152_((Screen)new ProductManagerScreen(previous));
        }
    }

    @Override
    protected void preDraw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int offsetY;
        this.m_280273_(guiGraphics);
        this.usernameField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.passwordField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280488_(this.f_96547_, "Username or Email", this.usernameField.m_252754_(), this.usernameField.m_252907_() - 10, 0xA0A0A0);
        guiGraphics.m_280488_(this.f_96547_, "Password", this.passwordField.m_252754_(), this.passwordField.m_252907_() - 10, 0xA0A0A0);
        if (this.attemptedLoginResponse != null && !this.attemptedLoginResponse.isSuccess()) {
            offsetY = this.passwordField.m_252907_() + 40;
            guiGraphics.m_280137_(this.f_96547_, this.attemptedLoginResponse.getMessage(), this.f_96543_ / 2, offsetY, 0xFF0000);
        } else if (this.errorThrown) {
            offsetY = this.passwordField.m_252907_() + 40;
            guiGraphics.m_280137_(this.f_96547_, this.errorMessage, this.f_96543_ / 2, offsetY, 0xFF0000);
        }
        guiGraphics.m_280488_(this.f_96547_, "Username or Email", this.usernameField.m_252754_(), this.usernameField.m_252907_() - 10, 0xA0A0A0);
        guiGraphics.m_280488_(this.f_96547_, "Password", this.passwordField.m_252754_(), this.passwordField.m_252907_() - 10, 0xA0A0A0);
        if (this.attemptedLoginResponse != null && !this.attemptedLoginResponse.isSuccess()) {
            offsetY = this.passwordField.m_252907_() + 40;
            guiGraphics.m_280137_(this.f_96547_, this.attemptedLoginResponse.getMessage(), this.f_96543_ / 2, offsetY, 0xFF0000);
        } else if (this.errorThrown) {
            offsetY = this.passwordField.m_252907_() + 40;
            guiGraphics.m_280137_(this.f_96547_, this.errorMessage, this.f_96543_ / 2, offsetY, 0xFF0000);
        }
    }

    @Override
    protected void postDraw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }
}

