/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge120.gui.panel;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import graphics.continuum.forge120.gui.FocalGuiUtils;
import graphics.continuum.forge120.gui.screen.GuiScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector4f;

public abstract class GuiFocusablePanel
extends AbstractContainerEventHandler
implements Renderable {
    protected final Minecraft client;
    protected final GuiScreen parent;
    protected final int width;
    protected final int height;
    protected final int left;
    protected final int top;
    protected final int right;
    protected final int bottom;
    private final List<GuiEventListener> children = Lists.newArrayList();

    public GuiFocusablePanel(GuiScreen parent, int left, int top, int width, int height) {
        this.parent = parent;
        this.client = Minecraft.m_91087_();
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.right = left + width;
        this.bottom = top + height;
    }

    public abstract void m_88315_(GuiGraphics var1, int var2, int var3, float var4);

    public abstract void tick();

    protected void drawGradientBackground(int left, int top, int width, int height) {
        Vector4f backgroundColor = new Vector4f(0.06f, 0.06f, 0.06f, 0.75f);
        FocalGuiUtils.drawGradientRect(left, top, left + width, top + height, backgroundColor, backgroundColor);
    }

    protected void drawDirtBackground(int left, int top, int width, int height) {
        int right = left + width;
        int bottom = top + height;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder worldr = tess.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float texScale = 32.0f;
        worldr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        worldr.m_5483_((double)left, (double)bottom, 0.0).m_7421_((float)left / 32.0f, (float)bottom / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        worldr.m_5483_((double)right, (double)bottom, 0.0).m_7421_((float)right / 32.0f, (float)bottom / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        worldr.m_5483_((double)right, (double)top, 0.0).m_7421_((float)right / 32.0f, (float)top / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        worldr.m_5483_((double)left, (double)top, 0.0).m_7421_((float)left / 32.0f, (float)top / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        tess.m_85914_();
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public void addChild(GuiEventListener child) {
        this.children.add(child);
    }

    public void removeChild(GuiEventListener child) {
        this.children.remove(child);
    }

    public Minecraft getClient() {
        return this.client;
    }

    public GuiScreen getParent() {
        return this.parent;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }
}

