/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge120.gui.data;

import com.google.common.collect.Lists;
import graphics.continuum.data.copp.ContinuumProduct;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.forge120.gui.FocalGuiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ProductPanelContents {
    private final Font font;
    private final SortType<ContinuumProductItem> sortType = new SortType();
    private final int maxLineLength;
    private int contentLength;
    private final int CONTENT_PADDING = 5;
    private final List<List<Component>> description = Lists.newArrayList((Iterable)Lists.newArrayList());
    private final List<ChangelogEntry> changelog = Lists.newArrayList();

    public ProductPanelContents(Font font, int maxLineLength) {
        this.font = font;
        this.maxLineLength = maxLineLength;
        this.contentLength = 0;
    }

    public void update(ContinuumProduct selectedProduct) {
        this.clear();
        ArrayList tempList = Lists.newArrayList();
        selectedProduct.getProductType().getDescription().forEach(paragraph -> {
            tempList.clear();
            tempList.add(paragraph);
            List<Component> wrappedParagraph = FocalGuiUtils.wrapText(tempList, this.font, this.maxLineLength);
            this.description.add(wrappedParagraph);
            Objects.requireNonNull(this.font);
            this.contentLength += 9 * (1 + wrappedParagraph.size());
        });
    }

    public void clear() {
        this.description.forEach(List::clear);
        this.description.clear();
        this.changelog.clear();
        this.contentLength = 0;
    }

    public void draw(GuiGraphics guiGraphics, int left, int top, int scrollDistance) {
        for (List<Component> paragraph : this.description) {
            for (Component line : paragraph) {
                guiGraphics.m_280430_(this.font, line, left + 6, top - scrollDistance, -1);
                Objects.requireNonNull(this.font);
                top += 9;
            }
            Objects.requireNonNull(this.font);
            top += 9;
        }
        for (ChangelogEntry changelogEntry : this.changelog) {
            for (Component line : changelogEntry.entryContents) {
                guiGraphics.m_280430_(this.font, line, left + 6, top - scrollDistance, -1);
                Objects.requireNonNull(this.font);
                top += 9;
            }
            top += this.CONTENT_PADDING;
        }
    }

    public int getLength() {
        return this.contentLength;
    }

    private static class SortType<T extends Comparable<T>>
    implements Comparator<T> {
        private SortType() {
        }

        @Override
        public int compare(T a, T b) {
            return b.compareTo(a);
        }
    }

    private static class ChangelogEntry {
        private final ProductPanelContents panelContents;
        private final Component entryName;
        private final List<Component> entryContents;

        ChangelogEntry(ProductPanelContents panelContents, ContinuumProductItem productItem) {
            this.panelContents = panelContents;
            this.entryName = null;
            this.entryContents = FocalGuiUtils.wrapText(Collections.singletonList(productItem.description.replace("\n", "")), panelContents.font, panelContents.maxLineLength);
        }

        public int getEntryLength() {
            int n = this.entryContents.size();
            Objects.requireNonNull(this.panelContents.font);
            return n * 9 + this.panelContents.CONTENT_PADDING;
        }

        public Component getEntryName() {
            return this.entryName;
        }

        public List<Component> getEntryContents() {
            return this.entryContents;
        }
    }
}

