/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric1204.mixin.api;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.shaderpack.ShaderpackInfo;
import graphics.continuum.fabric1204.gui.toasts.TextToast;
import graphics.continuum.fabric1204.mixin.access.GameRendererInvoker;
import graphics.continuum.fabric1204.mixin.access.ShadersMultiTexTextureManagerAccess;
import graphics.continuum.fabric1204.mixin.access.TextureAtlasAccessor;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.texture.TextureProxy;
import graphics.continuum.renderer.uniform.GlobalUniforms;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResources;
import graphics.continuum.util.Reference;
import net.minecraft.class_1059;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.optifine.shaders.ItemAliases;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.Shaders;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FocalEngineGameInterface.class}, remap=false)
public class FocalEngineGameInterfaceMixin {
    @Overwrite
    public static void sendMessage(String message) {
        if (class_310.method_1551().field_1705 != null && class_310.method_1551().field_1705.method_1743() != null) {
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)message));
        }
    }

    @Overwrite
    public static void sendToast(String title, String body) {
        class_310.method_1551().method_1566().method_1999((class_368)new TextToast(title, body));
    }

    @Overwrite
    public static void registerMinecraftTextures(TextureManager textureManager) {
        textureManager.initializeTextureProxy("minecraftFBOColor", new Reference<Integer>(0));
        textureManager.initializeTextureProxy("minecraftFBODepth", new Reference<Integer>(0));
        textureManager.initializeTextureProxy("blockAlbedoAtlas", new Reference<Integer>(0));
        textureManager.initializeTextureProxy("blockNormalAtlas", new Reference<Integer>(0));
        textureManager.initializeTextureProxy("blockSpecularAtlas", new Reference<Integer>(0));
    }

    @Overwrite
    public static void updateMinecraftTextures(TextureManager textureManager) {
        class_276 mcFrameBuffer = class_310.method_1551().method_1522();
        ((TextureProxy)textureManager.getTexture("minecraftFBOColor")).updateTextureID(mcFrameBuffer.method_30277());
        ((TextureProxy)textureManager.getTexture("minecraftFBODepth")).updateTextureID(mcFrameBuffer.method_30278());
        MultiTexID blockAtlasTextures = ((ShadersMultiTexTextureManagerAccess)class_310.method_1551().method_1531().method_4619(class_1059.field_5275)).invoker$getMultiTexID();
        ((TextureProxy)textureManager.getTexture("blockAlbedoAtlas")).updateTextureID(blockAtlasTextures.base);
        ((TextureProxy)textureManager.getTexture("blockNormalAtlas")).updateTextureID(blockAtlasTextures.norm);
        ((TextureProxy)textureManager.getTexture("blockSpecularAtlas")).updateTextureID(blockAtlasTextures.spec);
    }

    @Overwrite
    public static String getUsername() {
        return class_310.method_1551().method_1548().method_1676();
    }

    @Overwrite
    public static String getUuid() {
        return class_310.method_1551().method_1548().method_44717().toString();
    }

    @Overwrite
    public static String getGameVersion() {
        return class_310.method_1551().method_1515();
    }

    @Overwrite
    public static int getFontWidth(String line) {
        return class_310.method_1551().field_1772.method_1727(line);
    }

    @Overwrite
    public static int getMainRenderTargetID() {
        return class_310.method_1551().method_1522().field_1476;
    }

    @Overwrite
    public static int getMainRenderTargetWidth() {
        return class_310.method_1551().method_1522().field_1482;
    }

    @Overwrite
    public static int getMainRenderTargetHeight() {
        return class_310.method_1551().method_1522().field_1481;
    }

    @Overwrite
    public static void updateTrackedWindowUniforms(TrackedResources tracked) {
        int windowWidth = class_310.method_1551().method_22683().method_4489();
        int windowHeight = class_310.method_1551().method_22683().method_4506();
        tracked.markUniformUpdate("renderScale", Float.valueOf(Shaders.configRenderResMul));
        int scaledWindowWidth = (int)((float)windowWidth * Shaders.configRenderResMul);
        int scaledWindowHeight = (int)((float)windowHeight * Shaders.configRenderResMul);
        tracked.markUniformUpdate("windowWidth", scaledWindowWidth);
        tracked.markUniformUpdate("windowHeight", scaledWindowHeight);
        tracked.markUniformUpdate("aspectRatio", Float.valueOf((float)scaledWindowWidth / (float)scaledWindowHeight));
        tracked.markUniformUpdate("pixelSize", new Vector2f((float)(1.0 / (double)scaledWindowWidth), (float)(1.0 / (double)scaledWindowHeight)));
        tracked.markUniformUpdate("nativeWindowWidth", windowWidth);
        tracked.markUniformUpdate("nativeWindowHeight", windowHeight);
    }

    @Unique
    private static int focal$getDimensionId(class_1937 world) {
        return world == null ? 0 : FocalEngineGameInterfaceMixin.focal$getDimensionId((class_5321<class_1937>)world.method_27983());
    }

    @Unique
    private static int focal$getDimensionId(class_5321<class_1937> dimension) {
        if (dimension == class_1937.field_25180) {
            return -1;
        }
        if (dimension == class_1937.field_25181) {
            return 1;
        }
        return 0;
    }

    @Overwrite
    public static void updateTrackedInGameUniforms(TrackedResources tracked) {
        class_638 clientWorld = class_310.method_1551().field_1687;
        class_1297 viewEntity = class_310.method_1551().method_1560();
        float partialTicks = class_310.method_1551().method_1488();
        class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
        ShaderpackInfo info = FocalEngineCore.getInstance().getShaderpackManager().getCurrentShaderpack().getShaderpackInfo();
        if (clientWorld != null && viewEntity != null && class_310.method_1551().field_1724 != null) {
            TextureAtlasAccessor atlas = (TextureAtlasAccessor)class_310.method_1551().method_1531().method_4619(class_1723.field_21668);
            Vector3f cameraPosition = new Vector3f((float)renderInfo.method_19326().field_1352, (float)renderInfo.method_19326().field_1351, (float)renderInfo.method_19326().field_1350);
            tracked.markUniformUpdate("previousCameraPosition", (Boolean)tracked.getTrackedUniform("firstFrame").getValue() != false ? cameraPosition : tracked.getTrackedUniform("cameraPosition").getValue());
            tracked.markUniformUpdate("cameraPosition", cameraPosition);
            tracked.markUniformUpdate("atlasDimensions", new Vector2i(atlas.accessor$getWidth(), atlas.accessor$getHeight()));
            tracked.markUniformUpdate("atlasTexelSize", new Vector2f(1.0f / (float)atlas.accessor$getWidth(), 1.0f / (float)atlas.accessor$getHeight()));
            int previousWorldTime = (Integer)tracked.getTrackedUniform("worldTime").getValue();
            tracked.markUniformUpdate("previousWorldTime", previousWorldTime);
            tracked.markUniformUpdate("worldTime", (int)(clientWorld.method_8532() % 24000L));
            tracked.markUniformUpdate("worldDay", (int)(clientWorld.method_8532() / 24000L));
            tracked.markUniformUpdate("moonPhase", clientWorld.method_30273());
            tracked.markUniformUpdate("brightness", Float.valueOf((float)((Double)class_310.method_1551().field_1690.method_42473().method_41753()).doubleValue()));
            tracked.markUniformUpdate("blindness", Float.valueOf(class_310.method_1551().field_1724.method_6059(class_1294.field_5919) ? 1.0f : 0.0f));
            tracked.markUniformUpdate("nausea", Float.valueOf(class_310.method_1551().field_1724.method_6059(class_1294.field_5916) ? 1.0f : 0.0f));
            tracked.markUniformUpdate("nightVision", Float.valueOf(class_310.method_1551().field_1724.method_6059(class_1294.field_5925) ? 1.0f : 0.0f));
            FocalEngineGameInterfaceMixin.focal$figureOutRainStrength(tracked, clientWorld, partialTicks);
            class_243 lookDirection = viewEntity.method_5720();
            Vector3f viewVector = new Vector3f((float)lookDirection.field_1352, (float)lookDirection.field_1351, (float)lookDirection.field_1350);
            tracked.markUniformUpdate("viewVector", viewVector);
            float farClippingPlane = Math.max((float)((Integer)class_310.method_1551().field_1690.method_42503().method_41753()).intValue() * 32.0f, 173.0f);
            tracked.markUniformUpdate("near", Float.valueOf(0.05f));
            tracked.markUniformUpdate("far", Float.valueOf(farClippingPlane));
            tracked.markUniformUpdate("dimensionID", FocalEngineGameInterfaceMixin.focal$getDimensionId((class_1937)clientWorld));
            class_5636 cameraFluidState = renderInfo.method_19334();
            if (cameraFluidState == class_5636.field_27886) {
                tracked.markUniformUpdate("isEyeInWater", 1);
            } else if (cameraFluidState == class_5636.field_27885) {
                tracked.markUniformUpdate("isEyeInWater", 2);
            } else {
                tracked.markUniformUpdate("isEyeInWater", 0);
            }
            if (++GlobalUniforms.frameCounter >= 720720) {
                GlobalUniforms.frameCounter = 0;
            }
            long systemTime = System.currentTimeMillis();
            if (GlobalUniforms.lastSystemTime == 0L) {
                GlobalUniforms.lastSystemTime = systemTime;
            }
            long diffSystemTime = systemTime - GlobalUniforms.lastSystemTime;
            GlobalUniforms.lastSystemTime = systemTime;
            float frameTime = (float)diffSystemTime / 1000.0f;
            GlobalUniforms.frameTimeCounter += frameTime;
            tracked.markUniformUpdate("frameCounter", GlobalUniforms.frameCounter);
            tracked.markUniformUpdate("frameTime", Float.valueOf(frameTime));
            tracked.markUniformUpdate("frameTimeCounter", Float.valueOf(GlobalUniforms.frameTimeCounter %= 3600.0f));
            tracked.markUniformUpdate("nextTaaJitter", GlobalUniforms.taaJitterOffsets[Math.max(0, GlobalUniforms.frameCounter + 1) % 16].div((float)class_310.method_1551().method_22683().method_4489(), (float)class_310.method_1551().method_22683().method_4506(), new Vector2f()));
            tracked.markUniformUpdate("previousTaaJitter", GlobalUniforms.taaJitterOffsets[Math.max(0, GlobalUniforms.frameCounter - 1) % 16].div((float)class_310.method_1551().method_22683().method_4489(), (float)class_310.method_1551().method_22683().method_4506(), new Vector2f()));
            tracked.markUniformUpdate("taaJitter", GlobalUniforms.taaJitterOffsets[GlobalUniforms.frameCounter % 16].div((float)class_310.method_1551().method_22683().method_4489(), (float)class_310.method_1551().method_22683().method_4506(), new Vector2f()));
            float rainStrength = ((Float)tracked.getTrackedUniform("rainStrength").getValue()).floatValue();
            float fadeScalarRain = (float)diffSystemTime * 0.01f;
            float wetnessHalflife = info.getWetnessHalfLife().floatValue();
            float drynessHalflife = info.getDrynessHalfLife().floatValue();
            float previousWetness = ((Float)tracked.getTrackedUniform("wetness").getValue()).floatValue();
            float tempRain = (float)Math.exp(Math.log(0.5) * (double)fadeScalarRain / (double)(previousWetness < rainStrength ? drynessHalflife : wetnessHalflife));
            tracked.markUniformUpdate("wetness", Float.valueOf(previousWetness * tempRain + rainStrength * (1.0f - tempRain)));
            wetnessHalflife = info.getWetness2HalfLife().floatValue();
            drynessHalflife = info.getDryness2HalfLife().floatValue();
            previousWetness = ((Float)tracked.getTrackedUniform("wetness2").getValue()).floatValue();
            tempRain = (float)Math.exp(Math.log(0.5) * (double)fadeScalarRain / (double)(previousWetness < rainStrength ? drynessHalflife : wetnessHalflife));
            tracked.markUniformUpdate("wetness2", Float.valueOf(previousWetness * tempRain + rainStrength * (1.0f - tempRain)));
            class_1799 mainItemStack = class_310.method_1551().field_1724.method_6047();
            class_1792 mainItem = mainItemStack.method_7909();
            class_1799 offItemStack = class_310.method_1551().field_1724.method_6079();
            class_1792 offItem = offItemStack.method_7909();
            int mainHandID = -1;
            mainHandID = class_7923.field_41178.method_10206((Object)mainItem);
            mainHandID = ItemAliases.getItemAliasId((int)mainHandID);
            int offHandID = -1;
            offHandID = class_7923.field_41178.method_10206((Object)offItem);
            offHandID = ItemAliases.getItemAliasId((int)offHandID);
            tracked.markUniformUpdate("heldItem", new Vector2i(mainHandID, offHandID));
            int packedLightAtPlayerEye = class_310.method_1551().method_1561().method_23839(viewEntity, partialTicks);
            tracked.markUniformUpdate("eyeBrightness", new Vector2f((float)(packedLightAtPlayerEye & 0xFFFF), (float)(packedLightAtPlayerEye >> 16)));
            float eyeBrightnessHalfLife = info.getEyeBrightnessHalfLife().floatValue();
            float fadeScalarBrightness = (float)diffSystemTime * 0.01f;
            float tempBrightness = (float)Math.exp(Math.log(0.5) * (double)fadeScalarBrightness / (double)eyeBrightnessHalfLife);
            Vector2f previousEyeBrightnessSmooth = (Vector2f)tracked.getTrackedUniform("eyeBrightnessSmooth").getValue();
            Vector2f eyeBrightnessSmooth = new Vector2f(previousEyeBrightnessSmooth.x * tempBrightness + (float)(packedLightAtPlayerEye & 0xFFFF) * (1.0f - tempBrightness), previousEyeBrightnessSmooth.y * tempBrightness + (float)(packedLightAtPlayerEye >> 16) * (1.0f - tempBrightness));
            tracked.markUniformUpdate("eyeBrightnessSmooth", eyeBrightnessSmooth);
            tracked.markUniformUpdate("cameraFov", Float.valueOf((float)((GameRendererInvoker)class_310.method_1551().field_1773).invokeGetFov(class_310.method_1551().field_1773.method_19418(), class_310.method_1551().method_1488(), true)));
        }
    }

    @Unique
    private static void focal$figureOutRainStrength(TrackedResources tracked, class_638 clientWorld, float partialTicks) {
        TrackedResource trackedRainStrength = tracked.getTrackedUniform("rainStrength");
        float rainStrength = clientWorld.method_8430(partialTicks);
        if (trackedRainStrength.getValue() == null || (clientWorld.method_28104().method_156() || (double)rainStrength != 1.0) && (!clientWorld.method_28104().method_156() || (double)rainStrength != 0.0) || rainStrength == 0.0f && ((Float)trackedRainStrength.getValue()).floatValue() == 1.0f || rainStrength == 1.0f && ((Float)trackedRainStrength.getValue()).floatValue() == 0.0f) {
            trackedRainStrength.update(Float.valueOf(rainStrength));
        }
    }
}

