/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric1204.gui.widget;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.fabric1204.gui.FocalGuiUtils;
import graphics.continuum.fabric1204.gui.screen.IProductListUser;
import graphics.continuum.product.DownloadManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import org.joml.Vector4f;

public class ProductListWidget
extends class_4280<Entry>
implements AutoCloseable {
    private final IProductListUser parent;

    public ProductListWidget(IProductListUser parent, int width, int height, int topPadding, int bottomPadding) {
        class_310 class_3102 = class_310.method_1551();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        super(class_3102, width, height - topPadding - bottomPadding, topPadding, 9 + 15);
        this.parent = parent;
    }

    public void refreshList() {
        this.method_25339();
        this.parent.getSortedProducts().forEach(product -> this.method_25321((class_350.class_351)new Entry(this, (ContinuumProductType)((Object)product))));
        if (this.method_25396().size() > 0) {
            this.parent.selectProductEntry((Entry)this.method_25396().get(0));
        }
    }

    public int method_25322() {
        return this.field_22758;
    }

    @Override
    public void close() throws Exception {
        for (Entry entry : this.method_25396()) {
            entry.close();
        }
    }

    public class Entry
    extends class_4280.class_4281<Entry>
    implements AutoCloseable {
        private final ProductListWidget parent;
        private final ContinuumProductType productType;

        public Entry(ProductListWidget owningList, ContinuumProductType productType) {
            this.parent = owningList;
            this.productType = productType;
        }

        public void method_25343(class_332 guiGraphics, int itemIndex, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float p_render_9_) {
            int entryLeft = this.parent.method_46426() + 5;
            int entryTop = rowTop + 5;
            guiGraphics.method_25303(((ProductListWidget)ProductListWidget.this).field_22740.field_1772, this.productType.getDisplayName(), entryLeft, entryTop, 0xFFFFFF);
            this.drawUpdateBar(entryLeft, entryTop + 12, rowWidth - 10);
        }

        private void drawUpdateBar(int left, int top, int width) {
            List<DownloadManager.DownloadRequest> activeDownloads = FocalEngineCore.getInstance().getDownloadManager().getDownloadsForProduct(this.productType);
            if (activeDownloads == null) {
                return;
            }
            Vector4f bgColor = new Vector4f(1.0f, 1.0f, 1.0f, 0.1f);
            Vector4f progressColor = new Vector4f(0.0f, 1.0f, 0.0f, 0.5f);
            Vector4f failedColor = new Vector4f(1.0f, 0.0f, 0.0f, 0.5f);
            if (activeDownloads.size() == 1) {
                DownloadManager.DownloadRequest download = activeDownloads.get(0);
                FocalGuiUtils.drawGradientRect(left - 1, top - 1, left + width + 1, top + 1, bgColor, bgColor);
                if (!download.hasFailed()) {
                    FocalGuiUtils.drawGradientRect(left - 1, top - 1, left + Math.round((float)(width + 1) * download.getProgress()), top + 1, progressColor, progressColor);
                } else {
                    FocalGuiUtils.drawGradientRect(left - 1, top - 1, left + width + 1, top + 1, failedColor, failedColor);
                }
            } else {
                int totalDownloads = activeDownloads.size();
                int barWidth = Math.round((float)(width + 2 - totalDownloads) / (float)totalDownloads);
                for (int i = 0; i < totalDownloads; ++i) {
                    DownloadManager.DownloadRequest download = activeDownloads.get(i);
                    int barLeft = left + barWidth * i + (i > 0 ? 1 : 0);
                    int barRight = left + barWidth * (i + 1);
                    int barRightDl = left + barWidth * i + Math.round((float)barWidth * download.getProgress());
                    FocalGuiUtils.drawGradientRect(barLeft, top - 1, barRight, top + 1, bgColor, bgColor);
                    if (!download.hasFailed()) {
                        FocalGuiUtils.drawGradientRect(barLeft, top - 1, barRightDl, top + 1, progressColor, progressColor);
                        continue;
                    }
                    FocalGuiUtils.drawGradientRect(barLeft, top - 1, barRight, top + 1, failedColor, failedColor);
                }
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
            this.parent.parent.selectProductEntry(this);
            return false;
        }

        @Override
        public void close() throws Exception {
        }

        public ContinuumProductType getProductType() {
            return this.productType;
        }

        public class_2561 method_37006() {
            return class_2561.method_43471((String)"");
        }
    }
}

