/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric1204.gui.widget;

import graphics.continuum.fabric1204.gui.panel.ProductInfoPanel;
import graphics.continuum.fabric1204.gui.widget.IDropdownMenuEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_6382;

public class DropdownMenuWidget<T extends IDropdownMenuEntry>
extends class_4264 {
    private final ProductInfoPanel productInfoPanel;
    private final SortType<T> sortType;
    protected final class_327 font;
    private final List<T> menuEntries = new ArrayList<T>();
    private T selectedEntry;
    private int maxEntryWidth;
    private boolean extended;

    public DropdownMenuWidget(ProductInfoPanel productInfoPanel, int x, int y, int width, int height, String dropdownButtonText) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)dropdownButtonText));
        this.sortType = new SortType();
        this.productInfoPanel = productInfoPanel;
        this.font = class_310.method_1551().field_1772;
        this.maxEntryWidth = 0;
        this.field_22763 = false;
    }

    public void addEntry(T entry) {
        this.menuEntries.add(entry);
        this.menuEntries.sort(this.sortType);
        this.maxEntryWidth = Math.max(this.maxEntryWidth, this.font.method_1727(entry.getText()));
        this.field_22763 = true;
    }

    public void addEntries(Collection<T> entries) {
        this.menuEntries.addAll(entries);
        this.menuEntries.sort(this.sortType);
        this.menuEntries.forEach(entry -> {
            this.maxEntryWidth = Math.max(this.maxEntryWidth, this.font.method_1727(entry.getText()));
        });
        this.field_22763 = !this.menuEntries.isEmpty();
    }

    public void addEntries(Collection<T> entries, Predicate<T> filter) {
        entries.removeIf(filter.negate());
        this.menuEntries.addAll(entries);
        this.menuEntries.sort(this.sortType);
        this.menuEntries.forEach(entry -> {
            this.maxEntryWidth = Math.max(this.maxEntryWidth, this.font.method_1727(entry.getText()));
        });
        this.field_22763 = !this.menuEntries.isEmpty();
    }

    public int getEntryIndex(T entry) {
        return this.menuEntries.indexOf(entry);
    }

    public void selectEntry(T entry) {
        this.selectedEntry = entry;
    }

    public void selectEntry(int index) {
        this.selectedEntry = (IDropdownMenuEntry)this.menuEntries.get(index);
    }

    public boolean isSelected(T entry) {
        return entry.equals(this.selectedEntry);
    }

    public void clearEntries() {
        this.menuEntries.clear();
        this.maxEntryWidth = 0;
        this.selectedEntry = null;
        this.field_22763 = false;
    }

    public List<T> getEntries() {
        return this.menuEntries;
    }

    public int getEntriesLength() {
        Objects.requireNonNull(this.font);
        return 9 * this.menuEntries.size() + 10;
    }

    public int getEntryIndexAt(int mouseX, int mouseY) {
        int top = this.method_46427() + this.field_22759 + 5;
        int bottom = top + this.getEntriesLength() - 10;
        if (mouseY < top || mouseY >= bottom || mouseX < this.method_46426() || mouseX > this.method_46426() + this.field_22758) {
            return -1;
        }
        float f = mouseY - top;
        Objects.requireNonNull(this.font);
        return (int)Math.floor(f / 9.0f);
    }

    public T getSelectedEntry() {
        return this.selectedEntry;
    }

    private boolean mouseInBounds(double mouseX, double mouseY, int top, int bottom, int left, int right, boolean extendedTest) {
        int dynamicBottom = extendedTest ? bottom + this.getEntriesLength() : bottom;
        return mouseX >= (double)left && mouseX <= (double)right && mouseY >= (double)top && mouseY <= (double)dynamicBottom;
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        boolean validClick = this.mouseInBounds(mouseX, mouseY, this.method_46427(), this.method_46427() + this.field_22759, this.method_46426(), this.method_46426() + this.field_22758, this.extended);
        return validClick;
    }

    public void method_25306() {
    }

    protected void method_48579(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean wasActive = this.field_22763;
        if (this.extended) {
            int index = 0;
            int hoveredEntry = this.getEntryIndexAt(pMouseX, pMouseY);
            int bgWidth = Math.max(this.maxEntryWidth + 10, this.field_22758);
            int bgLeft = this.method_46426() + this.field_22758 / 2 - bgWidth / 2;
            int bgOuterColor = -15921907;
            int bgInnerColor = -16777216;
            pGuiGraphics.method_25294(bgLeft, this.method_46427(), bgLeft + bgWidth - 1, this.method_46427() + this.field_22759 + this.getEntriesLength(), -15921907);
            pGuiGraphics.method_25294(bgLeft + 1, this.method_46427() + 1, bgLeft + bgWidth - 2, this.method_46427() + this.field_22759 + this.getEntriesLength() - 1, -16777216);
            for (IDropdownMenuEntry entry : this.menuEntries) {
                int n = this.method_46426();
                int n2 = this.method_46427() + this.field_22759 + 5;
                Objects.requireNonNull(this.font);
                entry.draw(pGuiGraphics, this, n, n2 + index * 9, index == hoveredEntry);
                ++index;
            }
            this.field_22763 = false;
        }
        super.method_48579(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.field_22763 = wasActive;
    }

    public void method_25348(double mouseX, double mouseY) {
        int hoveredEntry;
        if (this.mouseInBounds(mouseX, mouseY, this.method_46427(), this.method_46427() + this.field_22759, this.method_46426(), this.method_46426() + this.field_22758, false)) {
            this.setExtended(!this.extended);
        } else if (this.extended && this.mouseInBounds(mouseX, mouseY, this.method_46427(), this.method_46427() + this.field_22759, this.method_46426(), this.method_46426() + this.field_22758, true) && (hoveredEntry = this.getEntryIndexAt((int)mouseX, (int)mouseY)) > -1) {
            ((IDropdownMenuEntry)this.menuEntries.get(hoveredEntry)).onClick(this);
        }
        super.method_25348(mouseX, mouseY);
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public ProductInfoPanel getProductInfoPanel() {
        return this.productInfoPanel;
    }

    protected void method_47399(class_6382 pNarrationElementOutput) {
    }

    public static class SortType<T extends IDropdownMenuEntry>
    implements Comparator<T> {
        @Override
        public int compare(T a, T b) {
            return a.compareTo((IDropdownMenuEntry)b);
        }
    }
}

