/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric1204.gui.screen;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.fabric1204.gui.panel.ProductInfoPanel;
import graphics.continuum.fabric1204.gui.screen.AccountLoginScreen;
import graphics.continuum.fabric1204.gui.screen.DownloadManagerScreen;
import graphics.continuum.fabric1204.gui.screen.GuiScreen;
import graphics.continuum.fabric1204.gui.screen.IProductListUser;
import graphics.continuum.fabric1204.gui.widget.DropdownMenuWidget;
import graphics.continuum.fabric1204.gui.widget.IDropdownMenuEntry;
import graphics.continuum.fabric1204.gui.widget.ProductListWidget;
import graphics.continuum.network.ContinuumAccount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ProductManagerScreen
extends GuiScreen
implements IProductListUser {
    private List<ContinuumProductType> sortedProductsList;
    private SortType sortType = SortType.NORMAL;
    private DropdownMenuWidget<IDropdownMenuEntry> accountDropdown;
    private class_4185 loginButton;
    private ProductListWidget productSelectionList;
    private ProductInfoPanel productInfoPanel;
    private class_4185 downloadManagerButton;
    public final IDropdownMenuEntry accountLogoutEntry = new IDropdownMenuEntry(){

        @Override
        public String getText() {
            return "Logout";
        }

        @Override
        public void onClick(DropdownMenuWidget dropdown) {
            FocalEngineCore.getInstance().forgetAccount();
            ProductManagerScreen.this.method_25426();
        }
    };

    public ProductManagerScreen(class_437 previousScreen) {
        super(previousScreen, (class_2561)class_2561.method_43470((String)"Continuum Product Manager"));
    }

    @Override
    protected void method_25426() {
        int accountDropdownWidth;
        this.accountDropdown = null;
        this.loginButton = null;
        this.downloadManagerButton = null;
        this.productInfoPanel = null;
        this.productSelectionList = null;
        this.method_37067();
        ContinuumAccount account = this.getModInstance().getAccount();
        if (!account.isAdhocAccount()) {
            String accountName = this.getModInstance().getAccount().getUsername();
            accountDropdownWidth = this.field_22793.method_1727(accountName) + 10;
            this.accountDropdown = new DropdownMenuWidget(null, 5, 5, accountDropdownWidth, 20, accountName);
            this.accountDropdown.addEntry(this.accountLogoutEntry);
        } else {
            accountDropdownWidth = this.field_22793.method_1727("Login") + 10;
            this.loginButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Login"), button -> this.field_22787.method_1507((class_437)new AccountLoginScreen((class_437)this, null))).method_46433(5, 5).method_46437(accountDropdownWidth, 20).method_46431();
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.returnToPreviousScreen()).method_46433(this.field_22789 - 65, 5).method_46437(60, 20).method_46431());
        this.updateDisplayedProductList();
        int maxListWidth = 0;
        for (ContinuumProductType product : this.sortedProductsList) {
            maxListWidth = Math.max(maxListWidth, class_310.method_1551().field_1772.method_1727(product.getDisplayName()));
        }
        maxListWidth = Math.max(maxListWidth, 100) + 10;
        this.productInfoPanel = new ProductInfoPanel(this, maxListWidth + 10, 30, 5);
        this.method_37063((class_364)this.productInfoPanel);
        this.productSelectionList = new ProductListWidget(this, maxListWidth, this.field_22790, 30, 5);
        this.productSelectionList.refreshList();
        this.productSelectionList.method_46421(5);
        this.method_37063((class_364)this.productSelectionList);
        String downloadManagementText = "Current Downloads";
        this.downloadManagerButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)downloadManagementText), button -> class_310.method_1551().method_1507((class_437)new DownloadManagerScreen(this))).method_46433(10 + accountDropdownWidth, 5).method_46437(this.field_22793.method_1727(downloadManagementText) + 10, 20).method_46431();
        this.method_37063((class_364)this.downloadManagerButton);
        if (account.isAdhocAccount()) {
            this.method_37063((class_364)this.loginButton);
        } else {
            this.method_37063((class_364)this.accountDropdown);
        }
    }

    public void updateDisplayedProductList() {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        engineInstance.getProductManager().checkForUpdatesAndNotify();
        this.sortedProductsList = new ArrayList<ContinuumProductType>(engineInstance.getProductManager().getProductList().keySet());
        this.sortedProductsList.sort(this.sortType);
    }

    @Override
    public void method_25393() {
        this.productInfoPanel.tick();
    }

    @Override
    protected void preDraw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25434(guiGraphics);
        this.productSelectionList.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.productInfoPanel.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.accountDropdown != null) {
            this.accountDropdown.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void postDraw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void selectProductEntry(ProductListWidget.Entry entry) {
        this.productSelectionList.method_25313((class_350.class_351)entry);
        FocalEngineCore.getInstance().getProductManager().selectProduct(entry.getProductType());
        this.productInfoPanel.destroy();
        this.productInfoPanel.init();
    }

    @Override
    public Collection<ContinuumProductType> getSortedProducts() {
        return this.sortedProductsList;
    }

    public ProductInfoPanel getProductInfoPanel() {
        return this.productInfoPanel;
    }

    @Override
    public void returnToPreviousScreen() {
        super.returnToPreviousScreen();
    }

    static enum SortType implements Comparator<ContinuumProductType>
    {
        NORMAL("NORMAL"),
        A_TO_Z("A->Z"){

            @Override
            public int compare(ContinuumProductType a, ContinuumProductType b) {
                return a.getDisplayName().compareTo(b.getDisplayName());
            }
        }
        ,
        Z_TO_A("Z->A"){

            @Override
            public int compare(ContinuumProductType a, ContinuumProductType b) {
                return b.getDisplayName().compareTo(a.getDisplayName());
            }
        };

        private final String displayName;

        private SortType(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public int compare(ContinuumProductType a, ContinuumProductType b) {
            return a.compareTo(b);
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

