/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric1204.gui.screen;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.fabric1204.gui.panel.DownloadListPanel;
import graphics.continuum.fabric1204.gui.screen.GuiScreen;
import graphics.continuum.fabric1204.gui.screen.IProductListUser;
import graphics.continuum.fabric1204.gui.screen.ProductManagerScreen;
import graphics.continuum.fabric1204.gui.widget.ProductListWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class DownloadManagerScreen
extends GuiScreen
implements IProductListUser {
    private List<ContinuumProductType> sortedProductsList;
    private ProductManagerScreen.SortType sortType = ProductManagerScreen.SortType.NORMAL;
    private class_4185 backButton;
    private ProductListWidget productList;
    private DownloadListPanel downloadsList;

    public DownloadManagerScreen(class_437 previousScreen) {
        super(previousScreen, (class_2561)class_2561.method_43470((String)"Download Management"));
    }

    public void updateDisplayedProductList() {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        this.sortedProductsList = new ArrayList<ContinuumProductType>(engineInstance.getProductManager().getProductList().keySet());
        this.sortedProductsList.add(ContinuumProductType.ALL);
        this.sortedProductsList.sort(this.sortType);
    }

    @Override
    protected void method_25426() {
        String accountName = this.getModInstance().getAccount().getUsername();
        int accountDropdownWidth = this.field_22793.method_1727(accountName) + 10;
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.returnToPreviousScreen()).method_46433(this.field_22789 - 65, 5).method_46437(60, 20).method_46431();
        this.method_37063((class_364)this.backButton);
        this.updateDisplayedProductList();
        int maxListWidth = 0;
        for (ContinuumProductType product : this.sortedProductsList) {
            maxListWidth = Math.max(maxListWidth, class_310.method_1551().field_1772.method_1727(product.getDisplayName()));
        }
        maxListWidth = Math.max(maxListWidth, 100) + 10;
        this.productList = new ProductListWidget(this, maxListWidth, this.field_22790, 30, 5);
        this.productList.refreshList();
        this.method_37063((class_364)this.productList);
        this.downloadsList = new DownloadListPanel(this, maxListWidth + 10, 30, 5);
        this.method_37063((class_364)this.downloadsList);
    }

    @Override
    public void method_25393() {
        this.downloadsList.tick();
    }

    @Override
    protected void preDraw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25434(guiGraphics);
        this.productList.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.downloadsList.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void postDraw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public Collection<ContinuumProductType> getSortedProducts() {
        return this.sortedProductsList;
    }

    @Override
    public void selectProductEntry(ProductListWidget.Entry product) {
        this.productList.method_25313((class_350.class_351)product);
    }

    public ProductListWidget.Entry getSelectedProductEntry() {
        return (ProductListWidget.Entry)this.productList.method_25334();
    }
}

