/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric1204.gui.panel;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProduct;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.fabric1204.gui.FocalGuiUtils;
import graphics.continuum.fabric1204.gui.data.ProductPanelContents;
import graphics.continuum.fabric1204.gui.data.dropdown.banner.IInstallEntry;
import graphics.continuum.fabric1204.gui.data.dropdown.banner.ProductBuildEntry;
import graphics.continuum.fabric1204.gui.data.dropdown.banner.ProductProjectEntry;
import graphics.continuum.fabric1204.gui.data.dropdown.banner.StratumResolutionEntry;
import graphics.continuum.fabric1204.gui.panel.ScrollPanel;
import graphics.continuum.fabric1204.gui.screen.ProductManagerScreen;
import graphics.continuum.fabric1204.gui.widget.DropdownMenuWidget;
import graphics.continuum.product.ProductManager;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.joml.Vector4f;

public class ProductInfoPanel
extends ScrollPanel
implements class_6379 {
    protected final int padding;
    protected final class_327 bannerTitleFont;
    protected final class_327 panelTextFont;
    protected final ProductPanelContents contents;
    protected class_4185 installButton;
    protected DropdownMenuWidget<IInstallEntry> buildSelectionMenu;
    protected DropdownMenuWidget<IInstallEntry> resolutionSelectionMenu;
    protected DropdownMenuWidget<IInstallEntry> versionSelectionMenu;
    protected InstallState installState;

    public ProductInfoPanel(ProductManagerScreen parent, int listWidth, int top, int padding) {
        super(parent, listWidth, top, parent.field_22789 - listWidth - padding, parent.field_22790 - top - padding);
        this.padding = padding;
        this.bannerTitleFont = this.client.field_1772;
        this.panelTextFont = this.client.field_1772;
        this.contents = new ProductPanelContents(this.panelTextFont, this.width - 10);
        this.scissorTop += 35;
        this.init();
    }

    public void init() {
        this.scrollDistance = 0.0f;
        this.installState = InstallState.INVALID;
        ContinuumProduct selectedProduct = FocalEngineCore.getInstance().getProductManager().getSelectedProduct();
        if (selectedProduct == null) {
            return;
        }
        this.installButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.installState.getText()), button -> this.installState.onInstall(this)).method_46433(this.right - this.padding - 70, this.top + this.padding - 1).method_46437(70, 20).method_46431();
        this.addChild((class_364)this.installButton);
        int offset = this.installButton.method_25368() + 5;
        this.buildSelectionMenu = new DropdownMenuWidget(this, this.right - this.padding - offset - 50, this.top + this.padding - 1, 50, 20, "Build");
        this.addChild((class_364)this.buildSelectionMenu);
        offset += this.buildSelectionMenu.method_25368() + 5;
        if (selectedProduct.getProductType().equals((Object)ContinuumProductType.STRATUM)) {
            this.resolutionSelectionMenu = new DropdownMenuWidget(this, this.right - this.padding - offset - 65, this.top + this.padding - 1, 65, 20, "Resolution");
            this.addChild((class_364)this.resolutionSelectionMenu);
            ArrayList stratumResolutionEntries = new ArrayList();
            selectedProduct.getProductType().getResolutions(selectedProduct).forEach(resolution -> stratumResolutionEntries.add(new StratumResolutionEntry(resolution.getResolution(), resolution.isAccessible())));
            this.resolutionSelectionMenu.addEntries(stratumResolutionEntries);
            for (IInstallEntry entry : this.resolutionSelectionMenu.getEntries()) {
                if (!(entry instanceof StratumResolutionEntry) || ((StratumResolutionEntry)entry).getResolution() != selectedProduct.getMaxResolution()) continue;
                this.resolutionSelectionMenu.selectEntry(entry);
                break;
            }
            selectedProduct.selectResolution(selectedProduct.getMaxResolution());
        } else if (selectedProduct.getProductType().equals((Object)ContinuumProductType.CONTINUUM_EARLY_ACCESS)) {
            this.versionSelectionMenu = new DropdownMenuWidget(this, this.right - this.padding - offset - 50, this.top + this.padding - 1, 50, 20, "Version");
            this.addChild((class_364)this.versionSelectionMenu);
            ArrayList versions = new ArrayList();
            selectedProduct.getAllProjects().forEach(version -> versions.add(new ProductProjectEntry((String)version)));
            this.versionSelectionMenu.addEntries(versions);
            IInstallEntry defaultEntry = null;
            for (IInstallEntry entry : this.versionSelectionMenu.getEntries()) {
                if (!(entry instanceof ProductProjectEntry) || !entry.getText().equalsIgnoreCase("legacy")) continue;
                defaultEntry = entry;
                break;
            }
            if (defaultEntry == null) {
                defaultEntry = this.versionSelectionMenu.getEntries().get(0);
            }
            this.versionSelectionMenu.selectEntry(defaultEntry);
            selectedProduct.selectProject(defaultEntry.getText());
        }
        this.updateBuilds();
    }

    public void destroy() {
        this.removeChild((class_364)this.installButton);
        this.installButton = null;
        this.removeChild((class_364)this.buildSelectionMenu);
        this.buildSelectionMenu = null;
        this.removeChild((class_364)this.resolutionSelectionMenu);
        this.resolutionSelectionMenu = null;
        this.removeChild((class_364)this.versionSelectionMenu);
        this.versionSelectionMenu = null;
        this.contents.clear();
    }

    @Override
    public void tick() {
        InstallState selectedVersionInstallState;
        if (this.installButton == null) {
            return;
        }
        ProductBuildEntry selectedVersionEntry = (ProductBuildEntry)this.buildSelectionMenu.getSelectedEntry();
        InstallState installState = selectedVersionInstallState = selectedVersionEntry != null ? selectedVersionEntry.getInstallState() : InstallState.INVALID;
        if (!this.installState.equals((Object)selectedVersionInstallState)) {
            this.setInstallState(selectedVersionInstallState);
        }
        this.installButton.method_25355((class_2561)class_2561.method_43470((String)this.installState.getText()));
        this.installButton.field_22763 = this.installState.isButtonEnabled();
    }

    public void updateBuilds() {
        boolean wasExtended = this.buildSelectionMenu.isExtended();
        this.buildSelectionMenu.setExtended(false);
        this.buildSelectionMenu.clearEntries();
        ContinuumProduct selectedProduct = FocalEngineCore.getInstance().getProductManager().getSelectedProduct();
        assert (selectedProduct != null);
        selectedProduct.getProductType().getItems(selectedProduct).forEach(productItem -> this.buildSelectionMenu.addEntry(new ProductBuildEntry((ContinuumProductItem)productItem)));
        boolean foundEntry = false;
        for (IInstallEntry entry : this.buildSelectionMenu.getEntries()) {
            if (!entry.isAccessible()) continue;
            entry.onClick(this.buildSelectionMenu);
            foundEntry = true;
            break;
        }
        if (!foundEntry && this.buildSelectionMenu.getEntries().size() > 0) {
            this.buildSelectionMenu.getEntries().get(0).onClick(this.buildSelectionMenu);
        }
        this.buildSelectionMenu.setExtended(wasExtended);
        this.contents.update(selectedProduct);
    }

    @Override
    protected void drawPreScissor(class_332 guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
        this.drawDirtBackground(this.left, this.top, this.width, this.height);
        Vector4f borderColor = new Vector4f(0.06f, 0.06f, 0.06f, 0.75f);
        Vector4f innerColor = new Vector4f(0.015f, 0.015f, 0.015f, 0.75f);
        FocalGuiUtils.drawGradientRect(this.left, this.top, this.right, this.scissorTop - 5, borderColor, borderColor);
        FocalGuiUtils.drawGradientRect(this.left + 1, this.top + 1, this.right - 1, this.scissorTop - 5 - 1, innerColor, innerColor);
        ProductManager productManager = FocalEngineCore.getInstance().getProductManager();
        if (productManager.getSelectedProduct() != null) {
            float scale = 1.0f;
            float scaleInv = 1.0f;
            float x = (float)(left + this.padding) * 1.0f;
            float y = ((float)(top + this.padding) + 5.0f) * 1.0f;
            guiGraphics.method_51433(this.bannerTitleFont, productManager.getSelectedProduct().getProductType().getDisplayName(), (int)x, (int)y, -1, true);
        }
    }

    @Override
    protected void drawScissor(class_332 guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
        this.contents.draw(guiGraphics, left, top, (int)this.scrollDistance);
    }

    @Override
    protected void drawPostScissor(class_332 guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
        if (this.installButton != null) {
            this.installButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.buildSelectionMenu != null) {
            this.buildSelectionMenu.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.resolutionSelectionMenu != null) {
            this.resolutionSelectionMenu.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.versionSelectionMenu != null) {
            this.versionSelectionMenu.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected int getContentHeight() {
        int height = this.contents.getLength();
        return height - (this.scissorBottom - this.scissorTop) + 5;
    }

    @Override
    protected int getScrollAmount() {
        Objects.requireNonNull(this.panelTextFont);
        return 9 * 3;
    }

    @Override
    protected int getMinScroll() {
        return 0;
    }

    public DropdownMenuWidget<IInstallEntry> getBuildSelectionMenu() {
        return this.buildSelectionMenu;
    }

    public class_327 getPanelTextFont() {
        return this.panelTextFont;
    }

    public void setInstallState(InstallState installState) {
        this.installState = installState;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 out) {
    }

    public static enum InstallState {
        CAN_DOWNLOAD_PRODUCT("Download", true){

            @Override
            public void onInstall(ProductInfoPanel productInfoPanel) {
                productInfoPanel.buildSelectionMenu.getSelectedEntry().onDownload(productInfoPanel);
            }
        }
        ,
        CAN_PURCHASE_PRODUCT("Purchase", true){

            @Override
            public void onInstall(ProductInfoPanel productInfoPanel) {
                productInfoPanel.buildSelectionMenu.getSelectedEntry().onPurchase(productInfoPanel);
            }
        }
        ,
        CAN_PURCHASE_STRATUM_TIER("Purchase", true){

            @Override
            public void onInstall(ProductInfoPanel productInfoPanel) {
                productInfoPanel.resolutionSelectionMenu.getSelectedEntry().onPurchase(productInfoPanel);
            }
        }
        ,
        CURRENTLY_DOWNLOADING_PRODUCT("Downloading", false){

            @Override
            public void onInstall(ProductInfoPanel productInfoPanel) {
            }
        }
        ,
        UNINSTALL("Uninstall", true){

            @Override
            public void onInstall(ProductInfoPanel productInfoPanel) {
                productInfoPanel.buildSelectionMenu.getSelectedEntry().onUninstall(productInfoPanel);
            }
        }
        ,
        INVALID("Download", false){

            @Override
            public void onInstall(ProductInfoPanel productInfoPanel) {
            }
        };

        private final String text;
        private final boolean buttonEnabled;

        private InstallState(String text, boolean buttonEnabled) {
            this.text = text;
            this.buttonEnabled = buttonEnabled;
        }

        public abstract void onInstall(ProductInfoPanel var1);

        public String getText() {
            return this.text;
        }

        public boolean isButtonEnabled() {
            return this.buttonEnabled;
        }
    }
}

