/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric120.mixin.patches;

import com.fasterxml.jackson.databind.JsonNode;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.fabric120.optifine.OptiFineBridgedShaderpack;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.config.ShaderOption;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Pseudo
@Mixin(targets={"net.optifine.shaders.config.ShaderPackParser"})
public abstract class ShaderPackParserMixin {
    @Shadow(remap=false)
    private static void collectShaderOptions(IShaderPack sp, String path, Map<String, ShaderOption> mapOptions) {
    }

    @Inject(method={"Lnet/optifine/shaders/config/ShaderPackParser;parseShaderPackOptions(Lnet/optifine/shaders/IShaderPack;[Ljava/lang/String;Ljava/util/List;)[Lnet/optifine/shaders/config/ShaderOption;"}, at={@At(value="INVOKE", target="Lnet/optifine/shaders/config/ShaderPackParser;collectShaderOptions(Lnet/optifine/shaders/IShaderPack;Ljava/lang/String;[Ljava/lang/String;Ljava/util/Map;)V", shift=At.Shift.AFTER, remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false)
    @Dynamic
    private static void parseFocalEngineOptions(IShaderPack shaderPack, String[] programNames, List<Integer> listDimensions, CallbackInfoReturnable<ShaderOption[]> cir, Map<String, ShaderOption> optionMap) {
        if (shaderPack instanceof OptiFineBridgedShaderpack) {
            try {
                ArrayList<String> shaderPaths = new ArrayList<String>();
                InputStream renderPassStream = shaderPack.getResourceAsStream("/renderpass.json");
                JsonNode node = JsonUtil.MAPPER.readTree(renderPassStream);
                renderPassStream.close();
                for (int i = 0; i < node.size(); ++i) {
                    JsonNode subNode = node.get(i);
                    if (subNode.has("groupName")) {
                        JsonNode passListNode = subNode.get("passes");
                        if (passListNode == null) continue;
                        for (int j = 0; j < passListNode.size(); ++j) {
                            JsonNode passNode = passListNode.get(j).get("shaders");
                            if (passNode == null) continue;
                            Iterator<String> fields = passNode.fieldNames();
                            while (fields.hasNext()) {
                                shaderPaths.add(passNode.get(fields.next()).asText());
                            }
                        }
                        continue;
                    }
                    JsonNode passNode = subNode.get("shaders");
                    if (passNode == null) continue;
                    Iterator<String> fields = passNode.fieldNames();
                    while (fields.hasNext()) {
                        shaderPaths.add(passNode.get(fields.next()).asText());
                    }
                }
                for (String shaderPath : shaderPaths) {
                    ShaderPackParserMixin.collectShaderOptions(shaderPack, shaderPath, optionMap);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

