/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric120.mixin.api;

import com.mojang.blaze3d.systems.RenderSystem;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.fabric120.mixin.access.ShadersFramebufferAccessor;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.texture.TextureProxy;
import graphics.continuum.tracking.TrackedResources;
import java.nio.FloatBuffer;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersFramebuffer;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Shaders.class})
public class OptifineTrackedUpdates {
    @Shadow(remap=false)
    @Dynamic
    static float[] sunPosition;
    @Shadow(remap=false)
    @Dynamic
    static float[] moonPosition;
    @Shadow(remap=false)
    @Dynamic
    static float[] shadowLightPosition;
    @Shadow(remap=false)
    @Final
    @Dynamic
    static FloatBuffer modelView;
    @Shadow(remap=false)
    @Dynamic
    static ShadersFramebuffer sfb;

    @Inject(method={"Lnet/optifine/shaders/Shaders;setCamera(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="RETURN")})
    @Dynamic
    private static void updateMatrixValues(class_4587 matrixStack, class_4184 activeRenderInfo, float partialTicks, CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            TrackedResources trackedResources = engineInstance.getTrackedResources();
            Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)matrixStack.method_23760().method_23761());
            Matrix4f modelViewMatrixInverse = new Matrix4f((Matrix4fc)modelViewMatrix).invert();
            Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
            Matrix4f projectionMatrixInverse = new Matrix4f((Matrix4fc)projectionMatrix).invert();
            trackedResources.markUniformUpdate("previousCameraViewMatrix", trackedResources.isTrackingUniform("cameraViewMatrix") ? trackedResources.getTrackedUniform("cameraViewMatrix").getValue() : modelViewMatrix);
            trackedResources.markUniformUpdate("previousCameraViewMatrixInverse", trackedResources.isTrackingUniform("cameraViewMatrixInverse") ? trackedResources.getTrackedUniform("cameraViewMatrixInverse").getValue() : modelViewMatrixInverse);
            trackedResources.markUniformUpdate("previousCameraProjectionMatrix", trackedResources.isTrackingUniform("cameraProjectionMatrix") ? trackedResources.getTrackedUniform("cameraProjectionMatrix").getValue() : projectionMatrix);
            trackedResources.markUniformUpdate("previousCameraProjectionMatrixInverse", trackedResources.isTrackingUniform("cameraProjectionMatrixInverse") ? trackedResources.getTrackedUniform("cameraProjectionMatrixInverse").getValue() : projectionMatrixInverse);
            trackedResources.markUniformUpdate("cameraViewMatrix", modelViewMatrix);
            trackedResources.markUniformUpdate("cameraViewMatrixInverse", modelViewMatrixInverse);
            trackedResources.markUniformUpdate("cameraProjectionMatrix", projectionMatrix);
            trackedResources.markUniformUpdate("cameraProjectionMatrixInverse", projectionMatrixInverse);
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;setCameraShadow(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="RETURN")})
    @Dynamic
    private static void updateShadowMatrixValues(class_4587 matrixStack, class_4184 activeRenderInfo, float partialTicks, CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            TrackedResources trackedResources = engineInstance.getTrackedResources();
            Matrix4f shadowModelViewMatrix = new Matrix4f((Matrix4fc)matrixStack.method_23760().method_23761());
            Matrix4f shadowModelViewMatrixInverse = new Matrix4f((Matrix4fc)shadowModelViewMatrix).invert();
            Matrix4f shadowProjectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
            Matrix4f shadowProjectionMatrixInverse = new Matrix4f((Matrix4fc)shadowProjectionMatrix).invert();
            trackedResources.markUniformUpdate("shadowViewMatrix", shadowModelViewMatrix);
            trackedResources.markUniformUpdate("shadowViewMatrixInverse", shadowModelViewMatrixInverse);
            trackedResources.markUniformUpdate("shadowProjectionMatrix", shadowProjectionMatrix);
            trackedResources.markUniformUpdate("shadowProjectionMatrixInverse", shadowProjectionMatrixInverse);
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;endWater()V"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void updateLightVectors(CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            TrackedResources trackedResources = engineInstance.getTrackedResources();
            trackedResources.markUniformUpdate("sunPosition", new Vector3f(sunPosition));
            trackedResources.markUniformUpdate("moonPosition", new Vector3f(moonPosition));
            trackedResources.markUniformUpdate("shadowLightPosition", new Vector3f(shadowLightPosition));
            Vector3f sunVector = new Vector3f(sunPosition).normalize();
            Vector3f moonVector = new Vector3f(moonPosition).normalize();
            Vector3f shadowLightVector = new Vector3f(shadowLightPosition).normalize();
            trackedResources.markUniformUpdate("sunVector", sunVector);
            trackedResources.markUniformUpdate("moonVector", moonVector);
            trackedResources.markUniformUpdate("shadowLightVector", shadowLightVector);
            Matrix4f modelViewMatrix = new Matrix4f(modelView);
            Matrix3f modelViewInverse3x3 = new Matrix3f((Matrix4fc)modelViewMatrix).invert();
            trackedResources.markUniformUpdate("wSunVector", new Vector3f((Vector3fc)sunVector).mul((Matrix3fc)modelViewInverse3x3));
            trackedResources.markUniformUpdate("wMoonVector", new Vector3f((Vector3fc)moonVector).mul((Matrix3fc)modelViewInverse3x3));
            trackedResources.markUniformUpdate("wShadowLightVector", new Vector3f((Vector3fc)shadowLightVector).mul((Matrix3fc)modelViewInverse3x3));
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;setEntityColor(FFFF)V"}, at={@At(value="INVOKE", target="Lnet/optifine/shaders/uniform/ShaderUniform4f;setValue(FFFF)V", remap=false, shift=At.Shift.AFTER)}, remap=false)
    @Dynamic
    private static void updateEntityColorValue(float r, float g, float b, float a, CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            engineInstance.getTrackedResources().markUniformUpdate("entityColor", new Vector4f(r, g, b, a));
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;setupShadowFrameBuffer()V"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void getShadowTextures(CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            TextureManager textureManager = FocalEngineCore.getInstance().getTextureManager();
            if (textureManager == null) {
                return;
            }
            ShadersFramebufferAccessor sfbAccessor = (ShadersFramebufferAccessor)sfb;
            ((TextureProxy)textureManager.getTexture("shadowtex0")).updateTextureID(sfbAccessor.accessor$getDepthTextures().get(0));
            ((TextureProxy)textureManager.getTexture("shadowtex1")).updateTextureID(sfbAccessor.accessor$getDepthTextures().get(1));
            ((TextureProxy)textureManager.getTexture("shadowcolor0")).updateTextureID(sfbAccessor.accessor$getColorTextures().getA(0));
            ((TextureProxy)textureManager.getTexture("shadowcolor1")).updateTextureID(sfbAccessor.accessor$getColorTextures().getA(1));
        }
    }
}

