/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric120.mixin.api;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.fabric120.optifine.OptiFineBridgedShaderpack;
import graphics.continuum.impl.api.optifine.OptifineShaderParser;
import graphics.continuum.shaderpack.FocalShaderpackBase;
import graphics.continuum.shaderpack.ShaderpackManager;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.MacroState;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.util.LineBuffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={OptifineShaderParser.class}, remap=false)
public class FocalEngineOptifineShaderParserMixin {
    @Overwrite
    public static StringBuilder getParsedShaderSource(String path) {
        StringBuilder stringBuilder = new StringBuilder(32768);
        ShaderpackManager shaderpackManager = FocalEngineCore.getInstance().getShaderpackManager();
        FocalShaderpackBase currentShaderpack = shaderpackManager.getCurrentShaderpack();
        try (InputStreamReader inputStreamReader = new InputStreamReader(currentShaderpack.getData(path));){
            LineBuffer reader = LineBuffer.readAll((Reader)inputStreamReader);
            reader = ShaderPackParser.addMacros((LineBuffer)reader, (int)0);
            ShaderOption[] ashaderoption = Shaders.getChangedOptions((ShaderOption[])Shaders.getShaderPackOptions());
            ArrayList list = new ArrayList();
            MacroState macrostate = new MacroState();
            LineBuffer adjustedReader = ShaderPackParser.resolveIncludes((LineBuffer)reader, (String)path, (IShaderPack)OptiFineBridgedShaderpack.getOptiFineBridge(currentShaderpack.getName()), (int)0, list, (int)0);
            for (String s : adjustedReader) {
                s = FocalEngineOptifineShaderParserMixin.focal_engine$applyOptions(s, ashaderoption);
                stringBuilder.append(s).append("\n");
                macrostate.processLine(s);
            }
        }
        catch (Exception e) {
            String errorMsg = String.join((CharSequence)"", "Failed to read '", path, "'.");
            FocalEngineCore.getInstance().getLogger().error(errorMsg);
            throw new IllegalStateException(errorMsg, e);
        }
        return stringBuilder;
    }

    @Unique
    private static String focal_engine$applyOptions(String line, ShaderOption[] ops) {
        if (ops != null && ops.length > 0) {
            for (ShaderOption shaderoption : ops) {
                if (!shaderoption.matchesLine(line)) continue;
                line = shaderoption.getSourceLine();
                break;
            }
            return line;
        }
        return line;
    }
}

