/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric120.gui.panel;

import com.google.common.collect.Lists;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.fabric120.gui.FocalGuiUtils;
import graphics.continuum.fabric120.gui.panel.ScrollPanel;
import graphics.continuum.fabric120.gui.screen.DownloadManagerScreen;
import graphics.continuum.product.DownloadManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.joml.Vector4f;

public class DownloadListPanel
extends ScrollPanel
implements class_6379 {
    private final DownloadManagerScreen parent;
    private final List<Entry> listEntries = Lists.newArrayList();

    public DownloadListPanel(DownloadManagerScreen parentScreen, int left, int top, int padding) {
        super(parentScreen, left, top, parentScreen.field_22789 - left - padding, parentScreen.field_22790 - top - padding);
        this.parent = parentScreen;
    }

    @Override
    protected int getContentHeight() {
        int totalHeight = 0;
        for (Entry listEntry : this.listEntries) {
            totalHeight += listEntry.parent.getHeight();
        }
        return totalHeight;
    }

    @Override
    protected int getScrollAmount() {
        return 1;
    }

    @Override
    protected int getMinScroll() {
        return 0;
    }

    @Override
    public void tick() {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        DownloadManager downloadManager = engineInstance.getDownloadManager();
        ArrayList<DownloadManager.DownloadRequest> activeDownloads = new ArrayList<DownloadManager.DownloadRequest>();
        if (this.parent.getSelectedProductEntry().getProductType() == ContinuumProductType.ALL) {
            downloadManager.getAllDownloads().values().forEach(activeDownloads::addAll);
        } else {
            activeDownloads.addAll(downloadManager.getDownloadsForProduct(this.parent.getSelectedProductEntry().getProductType()));
        }
        this.listEntries.clear();
        this.method_25396().clear();
        int cancelButtonHeight = 5;
        for (DownloadManager.DownloadRequest downloadRequest : activeDownloads) {
            Entry listEntry = new Entry(this, downloadRequest, this.top + cancelButtonHeight);
            this.listEntries.add(listEntry);
            cancelButtonHeight += listEntry.parent.getHeight();
        }
    }

    @Override
    protected void drawPreScissor(class_332 guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
        Vector4f bgColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.5f);
        FocalGuiUtils.drawGradientRect(left, top, this.right, this.bottom, bgColor, bgColor);
    }

    @Override
    protected void drawScissor(class_332 guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
        for (Entry listEntry : this.listEntries) {
            listEntry.render(guiGraphics, left, top, mouseX, mouseY, partialTicks);
            top += listEntry.getHeight();
        }
    }

    @Override
    protected void drawPostScissor(class_332 guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 pNarrationElementOutput) {
    }

    private static class Entry {
        private final Vector4f bgColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.1f);
        private final Vector4f fgColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.1f);
        private final Vector4f progressColor = new Vector4f(0.0f, 1.0f, 0.0f, 0.5f);
        private final Vector4f failedColor = new Vector4f(1.0f, 0.0f, 0.0f, 0.5f);
        private final DownloadListPanel parent;
        private final DownloadManager.DownloadRequest downloadRequest;
        private final class_4185 cancelButton;
        private final class_4185 restartButton;

        private Entry(DownloadListPanel parent, DownloadManager.DownloadRequest downloadRequest, int cancelButtonHeight) {
            this.parent = parent;
            this.downloadRequest = downloadRequest;
            this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> {
                if (!this.downloadRequest.hasFailed() && !this.downloadRequest.hasFinished()) {
                    this.downloadRequest.cancel();
                } else {
                    FocalEngineCore.getInstance().getDownloadManager().removeDownloadFromBin(this.downloadRequest.getProduct().product.getProductType(), this.downloadRequest);
                }
            }).method_46433(parent.right - 65, cancelButtonHeight).method_46437(60, 20).method_46431();
            this.cancelButton.field_22763 = downloadRequest.hasStarted();
            parent.addChild((class_364)this.cancelButton);
            this.restartButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Restart"), button -> {
                DownloadManager downloadManager = FocalEngineCore.getInstance().getDownloadManager();
                ContinuumProductItem productItem = this.downloadRequest.getProduct();
                downloadManager.removeDownloadFromBin(productItem.product.getProductType(), this.downloadRequest);
                downloadManager.downloadItem(productItem);
            }).method_46433(parent.right - this.cancelButton.method_25368() - 70, cancelButtonHeight).method_46437(60, 20).method_46431();
            this.restartButton.field_22763 = downloadRequest.hasFailed() || downloadRequest.wasCancelled();
            parent.addChild((class_364)this.restartButton);
        }

        public void render(class_332 guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
            class_327 fontRenderer = this.parent.getClient().field_1772;
            FocalGuiUtils.drawGradientRect(left, top, this.parent.right, top + this.getHeight(), this.bgColor, this.bgColor);
            FocalGuiUtils.drawGradientRect(left + 1, top + 1, this.parent.right - 1, top + this.getHeight() - 1, this.fgColor, this.fgColor);
            int textRight = this.parent.right - (this.downloadRequest.hasFinished() && !this.downloadRequest.hasFailed() ? 0 : this.cancelButton.method_25368() + 10) - 10;
            switch (this.downloadRequest.getState()) {
                case DOWNLOADING: 
                case FINISHED: {
                    FocalGuiUtils.drawGradientRect(left + 1, top + 1, left + Math.round((float)(this.parent.width - 1) * this.downloadRequest.getProgress()), top + this.getHeight() - 1, this.progressColor, this.progressColor);
                    if (this.downloadRequest.getState() != DownloadManager.DownloadState.DOWNLOADING) {
                        this.cancelButton.method_25355((class_2561)class_2561.method_43470((String)"Remove"));
                    } else {
                        String progressText = new DecimalFormat("###.0").format(this.downloadRequest.getProgress() * 100.0f) + "%";
                        guiGraphics.method_25303(fontRenderer, progressText, textRight - fontRenderer.method_1727(progressText), top + 11, -1);
                    }
                    this.cancelButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
                    break;
                }
                case FAILED: {
                    FocalGuiUtils.drawGradientRect(left + 1, top + 1, left + this.parent.width - 1, top + this.getHeight() - 1, this.failedColor, this.failedColor);
                    this.cancelButton.method_25355((class_2561)class_2561.method_43470((String)"Remove"));
                    this.cancelButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
                    this.restartButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
                }
            }
            String downloadName = this.parent.parent.getSelectedProductEntry().getProductType() == ContinuumProductType.ALL ? this.downloadRequest.getProduct().itemName : this.downloadRequest.getProduct().displayedVersionID;
            guiGraphics.method_25303(fontRenderer, downloadName, left + 5, top + 11, -1);
        }

        public int getHeight() {
            return 30;
        }
    }
}

