/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.fabric120.gui.data.dropdown.banner;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.fabric120.gui.data.dropdown.banner.IInstallEntry;
import graphics.continuum.fabric120.gui.panel.ProductInfoPanel;
import graphics.continuum.fabric120.gui.screen.ConfirmOpenLinkScreen;
import graphics.continuum.fabric120.gui.widget.DropdownMenuWidget;
import graphics.continuum.fabric120.gui.widget.IDropdownMenuEntry;
import net.minecraft.class_437;

public class StratumResolutionEntry
implements IInstallEntry {
    private final int resolution;
    private final boolean accessible;

    public StratumResolutionEntry(int resolution, boolean accessible) {
        this.resolution = resolution;
        this.accessible = accessible;
    }

    @Override
    public String getText() {
        return Integer.toString(this.resolution);
    }

    @Override
    public void onClick(DropdownMenuWidget dropdown) {
        ProductInfoPanel infoPanel = dropdown.getProductInfoPanel();
        dropdown.selectEntry(this);
        FocalEngineCore.getInstance().getProductManager().getProduct(ContinuumProductType.STRATUM).selectResolution(this.resolution);
        infoPanel.updateBuilds();
        if (!this.isAccessible()) {
            infoPanel.setInstallState(ProductInfoPanel.InstallState.CAN_PURCHASE_STRATUM_TIER);
        }
    }

    @Override
    public void onDownload(ProductInfoPanel productInfoPanel) {
    }

    @Override
    public void onPurchase(ProductInfoPanel productInfoPanel) {
        productInfoPanel.getClient().method_1507((class_437)new ConfirmOpenLinkScreen(productInfoPanel.getParent(), this::confirmLink, this.getPurchaseLink(), false));
    }

    @Override
    public void onUninstall(ProductInfoPanel productInfoPanel) {
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    @Override
    public int compareTo(IDropdownMenuEntry o) {
        if (o instanceof StratumResolutionEntry) {
            return Integer.compare(((StratumResolutionEntry)o).resolution, this.resolution);
        }
        return o.getText().compareTo(this.getText());
    }

    public int getResolution() {
        return this.resolution;
    }
}

