/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.texture;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.shaderpack.ShaderpackManager;
import graphics.continuum.tracking.TrackedResourceRelation;
import graphics.continuum.tracking.internal.IntRelationDeserializer;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL46C;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class TextureInfo {
    private final String name;
    private final TrackedResourceRelation<Integer> width;
    private final TrackedResourceRelation<Integer> height;
    private final TrackedResourceRelation<Integer> depth;
    private final Float downscaleFactorX;
    private final Float downscaleFactorY;
    private final Float downscaleFactorZ;
    private int levelOfDetail;
    private final boolean trueLod;
    private final boolean generateImageMipHandles;
    private final int pixelFormat;
    private final boolean pingPong;
    private final boolean clearA;
    private final boolean clearB;
    private final float[] clearColor;
    private final boolean shouldInitialize;
    private final String resourceLocation;
    private final TextureType textureType;
    private final boolean bindless;
    private final boolean autoGenerateMipmaps;
    private final boolean debugTarget;
    private final Map<Integer, Integer> params;

    @JsonCreator
    protected TextureInfo(@JsonProperty(value="name", required=true) String name, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="width") TrackedResourceRelation<Integer> width, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="height") TrackedResourceRelation<Integer> height, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="depth") TrackedResourceRelation<Integer> depth, @JsonProperty(value="downscaleFactor") Float downscaleFactor, @JsonProperty(value="downscaleFactorX") Float downscaleFactorX, @JsonProperty(value="downscaleFactorY") Float downscaleFactorY, @JsonProperty(value="downscaleFactorZ") Float downscaleFactorZ, @JsonProperty(value="levelOfDetail") Integer levelOfDetail, @JsonProperty(value="generateImageMipHandles") Boolean generateImageMipHandles, @JsonDeserialize(using=JsonUtil.OpenGLParamDeserializer.class) @JsonProperty(value="pixelFormat") int pixelFormat, @JsonProperty(value="pingPong") Boolean pingPong, @JsonProperty(value="cubemap") boolean cubemap, @JsonProperty(value="clear") Boolean clear, @JsonProperty(value="clearInternalTextures") List<Boolean> clearInternalTextures, @JsonProperty(value="clearColor") List<Number> clearColor, @JsonProperty(value="shouldInitialize") boolean shouldInitialize, @JsonDeserialize(keyUsing=JsonUtil.OpenGLParamKeyDeserializer.class, contentUsing=JsonUtil.OpenGLParamDeserializer.class) @JsonProperty(value="params") Map<Integer, Integer> params, @JsonProperty(value="resourceLocation") String resourceLocation, @JsonProperty(value="debugTarget") Boolean debugTarget, @JsonProperty(value="bindless") Boolean bindless, @JsonProperty(value="autoMipmap") Boolean autoGenerateMipmaps) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.downscaleFactorX = Float.valueOf(downscaleFactorX == null ? (downscaleFactor == null ? -1.0f : downscaleFactor.floatValue()) : downscaleFactorX.floatValue());
        this.downscaleFactorY = Float.valueOf(downscaleFactorY == null ? (downscaleFactor == null ? -1.0f : downscaleFactor.floatValue()) : downscaleFactorY.floatValue());
        this.downscaleFactorZ = Float.valueOf(downscaleFactorZ == null ? (downscaleFactor == null ? -1.0f : downscaleFactor.floatValue()) : downscaleFactorZ.floatValue());
        this.levelOfDetail = this.calculateLevelOfDetail(levelOfDetail == null ? -1 : levelOfDetail);
        this.trueLod = levelOfDetail == null || levelOfDetail == -1;
        this.generateImageMipHandles = generateImageMipHandles != null && generateImageMipHandles != false;
        this.bindless = bindless != null && bindless != false || this.generateImageMipHandles;
        this.pixelFormat = pixelFormat;
        this.pingPong = pingPong == null || pingPong != false;
        this.shouldInitialize = shouldInitialize;
        if (clear == null && clearInternalTextures == null) {
            this.clearA = true;
            this.clearB = true;
        } else if (clear != null && clearInternalTextures == null) {
            this.clearA = clear;
            this.clearB = clear;
        } else if (clear == null && clearInternalTextures.size() == 2) {
            this.clearA = clearInternalTextures.get(0);
            this.clearB = clearInternalTextures.get(1);
        } else {
            if (clear == null && clearInternalTextures.size() < 2) {
                throw new IllegalStateException("Internal texture clears must be defined for both internal textures.");
            }
            if (clear != null) {
                throw new IllegalStateException("Cannot clear both generically and specifically at the same time.");
            }
            throw new IllegalStateException("Unknown error occurred while creating a texture.");
        }
        if (clearColor == null) {
            this.clearColor = this.getDefaultClearColor();
        } else {
            float[] color = new float[]{clearColor.get(0).floatValue(), clearColor.get(1).floatValue(), clearColor.get(2).floatValue(), clearColor.get(3).floatValue()};
            this.clearColor = color;
        }
        this.params = params == null ? Collections.emptyMap() : params;
        this.resourceLocation = resourceLocation;
        this.debugTarget = debugTarget != null && debugTarget != false;
        boolean bl = this.autoGenerateMipmaps = autoGenerateMipmaps == null || autoGenerateMipmaps != false;
        this.textureType = cubemap ? TextureType.TEXTURE_CUBE : (!(height != null && height.getValue() != 1 || depth != null && depth.getValue() != 1) ? TextureType.TEXTURE_1D : (depth == null || depth.getValue() == 1 ? TextureType.TEXTURE_2D : TextureType.TEXTURE_3D));
    }

    public String getName() {
        return this.name;
    }

    public Integer getWidth() {
        return this.downscaleFactorX.floatValue() > 0.0f ? Integer.valueOf((int)Math.ceil((float)this.width.getValue().intValue() / this.downscaleFactorX.floatValue())) : this.width.getValue();
    }

    public Integer getHeight() {
        return this.downscaleFactorY.floatValue() > 0.0f ? Integer.valueOf((int)Math.ceil((float)this.height.getValue().intValue() / this.downscaleFactorY.floatValue())) : this.height.getValue();
    }

    public Integer getDepth() {
        return this.downscaleFactorZ.floatValue() > 0.0f ? Integer.valueOf((int)Math.ceil((float)this.depth.getValue().intValue() / this.downscaleFactorZ.floatValue())) : this.depth.getValue();
    }

    public boolean requiresUpdate() {
        boolean requiresUpdate = false;
        if (this.width != null) {
            requiresUpdate = this.width.requiresUpdate();
        }
        if (this.height != null) {
            requiresUpdate |= this.height.requiresUpdate();
        }
        if (this.depth != null) {
            requiresUpdate |= this.depth.requiresUpdate();
        }
        if (this.trueLod && requiresUpdate) {
            this.levelOfDetail = this.getTrueLod();
        }
        return requiresUpdate;
    }

    public TextureType getTextureType() {
        return this.textureType;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    private int getTrueLod() {
        int realWidth = this.getWidth();
        int realHeight = this.getHeight();
        long largestDimension = Math.max(realWidth, realHeight);
        double logSize = Math.log(largestDimension) / Math.log(2.0);
        return 1 + (int)Math.floor(logSize);
    }

    private int calculateLevelOfDetail(int lod) {
        if (this.height == null) {
            return lod;
        }
        int trueLod = this.getTrueLod();
        if (lod != -1) {
            trueLod = Math.min(trueLod, lod);
        }
        return trueLod;
    }

    public int getLevelOfDetail() {
        return this.levelOfDetail;
    }

    public boolean shouldGenerateMipHandles() {
        return this.generateImageMipHandles;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public int getPixelFormatLayout() {
        switch (this.pixelFormat) {
            case 33329: 
            case 33330: 
            case 33331: 
            case 33332: 
            case 33333: 
            case 33334: {
                return 36244;
            }
            case 33335: 
            case 33336: 
            case 33337: 
            case 33338: 
            case 33339: 
            case 33340: {
                return 33320;
            }
            case 36209: 
            case 36215: 
            case 36221: 
            case 36227: 
            case 36233: 
            case 36239: {
                return 36248;
            }
            case 36208: 
            case 36214: 
            case 36220: 
            case 36226: 
            case 36232: 
            case 36238: {
                return 36249;
            }
            case 33321: 
            case 33322: 
            case 33325: 
            case 33326: {
                return 6403;
            }
            case 33323: 
            case 33324: 
            case 33327: 
            case 33328: {
                return 33319;
            }
            case 32847: 
            case 32849: 
            case 32852: 
            case 34837: 
            case 34843: {
                return 6407;
            }
            case 32853: 
            case 32854: 
            case 32856: 
            case 32859: 
            case 34836: 
            case 34842: {
                return 6408;
            }
            case 33189: 
            case 33190: 
            case 33191: 
            case 36012: {
                return 6402;
            }
        }
        return -1;
    }

    public int getPixelFormatType() {
        switch (this.pixelFormat) {
            case 33329: 
            case 33335: 
            case 36238: 
            case 36239: {
                return 5120;
            }
            case 33331: 
            case 33337: 
            case 36232: 
            case 36233: {
                return 5122;
            }
            case 33333: 
            case 33339: 
            case 36226: 
            case 36227: {
                return 5124;
            }
            case 33330: 
            case 33336: 
            case 36220: 
            case 36221: {
                return 5121;
            }
            case 33332: 
            case 33338: 
            case 36214: 
            case 36215: {
                return 5123;
            }
            case 33334: 
            case 33340: 
            case 36208: 
            case 36209: {
                return 5125;
            }
            case 33325: 
            case 33327: 
            case 34842: 
            case 34843: {
                return 5131;
            }
            case 33326: 
            case 33328: 
            case 34836: 
            case 34837: 
            case 36012: {
                return 5126;
            }
            case 32847: 
            case 32849: 
            case 32852: 
            case 32853: 
            case 32854: 
            case 32856: 
            case 32859: 
            case 33189: 
            case 33190: 
            case 33191: 
            case 33321: 
            case 33322: 
            case 33323: 
            case 33324: {
                return 5126;
            }
        }
        return -1;
    }

    public boolean isBindless() {
        return this.bindless;
    }

    public boolean shouldAutoGenerateMipmaps() {
        return this.autoGenerateMipmaps;
    }

    public boolean isDebugTarget() {
        return this.debugTarget;
    }

    public boolean isPingPong() {
        return this.pingPong;
    }

    public boolean isLayered() {
        return this.textureType == TextureType.TEXTURE_CUBE || this.textureType == TextureType.TEXTURE_3D;
    }

    public boolean shouldClear() {
        return this.clearA || this.clearB;
    }

    public boolean shouldClearA() {
        return this.clearA;
    }

    public boolean shouldClearB() {
        return this.clearB;
    }

    public float[] getClearColor() {
        return this.clearColor;
    }

    public boolean shouldInitialize() {
        return this.shouldInitialize;
    }

    public float[] getDefaultClearColor() {
        switch (this.getPixelFormatLayout()) {
            case 6402: {
                return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    }

    public Map<Integer, Integer> getParameters() {
        return this.params;
    }

    public static enum TextureType {
        TEXTURE_1D{

            @Override
            public int createTexture() {
                return GL46C.glCreateTextures((int)3552);
            }

            @Override
            public void genTextureStorage(int textureID, TextureInfo textureInfo) {
                GL46C.glTextureStorage1D((int)textureID, (int)textureInfo.getLevelOfDetail(), (int)textureInfo.getPixelFormat(), (int)textureInfo.getWidth());
            }

            @Override
            public void loadEncodedImage(int textureID, TextureInfo textureInfo, ByteBuffer imageData) {
            }

            @Override
            public void loadBinaryImage(int textureID, TextureInfo textureInfo, ByteBuffer imageData) {
                GL46C.glTextureStorage1D((int)textureID, (int)1, (int)textureInfo.getPixelFormat(), (int)textureInfo.getWidth());
                GL46C.glTextureSubImage1D((int)textureID, (int)0, (int)0, (int)textureInfo.getWidth(), (int)textureInfo.getPixelFormatLayout(), (int)textureInfo.getPixelFormatType(), (ByteBuffer)imageData);
            }
        }
        ,
        TEXTURE_2D{

            @Override
            public int createTexture() {
                return GL46C.glCreateTextures((int)3553);
            }

            @Override
            public void genTextureStorage(int textureID, TextureInfo textureInfo) {
                GL46C.glTextureStorage2D((int)textureID, (int)textureInfo.getLevelOfDetail(), (int)textureInfo.getPixelFormat(), (int)textureInfo.getWidth(), (int)textureInfo.getHeight());
            }

            @Override
            public void loadEncodedImage(int textureID, TextureInfo textureInfo, ByteBuffer imageData) {
                int format = 6408;
                int internalFormat = 32856;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer w = stack.mallocInt(1);
                    IntBuffer h = stack.mallocInt(1);
                    IntBuffer comp = stack.mallocInt(1);
                    STBImage.stbi_set_flip_vertically_on_load((boolean)true);
                    ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)imageData, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp, (int)0);
                    STBImage.stbi_set_flip_vertically_on_load((boolean)false);
                    if (image == null) {
                        throw new RuntimeException("Failed to load a texture file!" + System.lineSeparator() + STBImage.stbi_failure_reason());
                    }
                    int width = w.get();
                    int height = h.get();
                    if (comp.get() == 3) {
                        internalFormat = 32849;
                        format = 6407;
                    }
                    GL46C.glTextureStorage2D((int)textureID, (int)1, (int)internalFormat, (int)width, (int)height);
                    GL46C.glTextureSubImage2D((int)textureID, (int)0, (int)0, (int)0, (int)width, (int)height, (int)format, (int)5121, (ByteBuffer)image);
                    STBImage.stbi_image_free((ByteBuffer)image);
                }
            }

            @Override
            public void loadBinaryImage(int textureID, TextureInfo textureInfo, ByteBuffer imageData) {
                GL46C.glTextureStorage2D((int)textureID, (int)1, (int)textureInfo.getPixelFormat(), (int)textureInfo.getWidth(), (int)textureInfo.getHeight());
                GL46C.glTextureSubImage2D((int)textureID, (int)0, (int)0, (int)0, (int)textureInfo.getWidth(), (int)textureInfo.getHeight(), (int)textureInfo.getPixelFormatLayout(), (int)textureInfo.getPixelFormatType(), (ByteBuffer)imageData);
            }
        }
        ,
        TEXTURE_3D{

            @Override
            public int createTexture() {
                return GL46C.glCreateTextures((int)32879);
            }

            @Override
            public void genTextureStorage(int textureID, TextureInfo textureInfo) {
                GL46C.glTextureStorage3D((int)textureID, (int)textureInfo.getLevelOfDetail(), (int)textureInfo.getPixelFormat(), (int)textureInfo.getWidth(), (int)textureInfo.getHeight(), (int)textureInfo.getDepth());
            }

            @Override
            public void loadEncodedImage(int textureID, TextureInfo textureInfo, ByteBuffer imageData) {
            }

            @Override
            public void loadBinaryImage(int textureID, TextureInfo textureInfo, ByteBuffer imageData) {
                GL46C.glTextureStorage3D((int)textureID, (int)1, (int)textureInfo.getPixelFormat(), (int)textureInfo.getWidth(), (int)textureInfo.getHeight(), (int)textureInfo.getDepth());
                GL46C.glTextureSubImage3D((int)textureID, (int)0, (int)0, (int)0, (int)0, (int)textureInfo.getWidth(), (int)textureInfo.getHeight(), (int)textureInfo.getDepth(), (int)textureInfo.getPixelFormatLayout(), (int)textureInfo.getPixelFormatType(), (ByteBuffer)imageData);
            }
        }
        ,
        TEXTURE_CUBE{

            @Override
            public int createTexture() {
                return GL46C.glCreateTextures((int)34067);
            }

            @Override
            public void genTextureStorage(int textureID, TextureInfo textureInfo) {
                GL46C.glTextureStorage2D((int)textureID, (int)textureInfo.getLevelOfDetail(), (int)textureInfo.getPixelFormat(), (int)textureInfo.getWidth(), (int)textureInfo.getHeight());
            }

            @Override
            public void loadEncodedImage(int textureID, TextureInfo textureInfo, ByteBuffer imageData) {
            }

            @Override
            public void loadBinaryImage(int textureID, TextureInfo textureInfo, ByteBuffer imageData) {
                GL46C.glTextureStorage3D((int)textureID, (int)1, (int)textureInfo.getPixelFormat(), (int)textureInfo.getWidth(), (int)textureInfo.getHeight(), (int)textureInfo.getDepth());
                GL46C.glTextureSubImage3D((int)textureID, (int)0, (int)0, (int)0, (int)0, (int)textureInfo.getWidth(), (int)textureInfo.getHeight(), (int)6, (int)textureInfo.getPixelFormatLayout(), (int)textureInfo.getPixelFormatType(), (ByteBuffer)imageData);
            }
        };


        public void loadImage(int textureID, TextureInfo textureInfo, String imageLocation) {
            try {
                ShaderpackManager shaderpackManager = FocalEngineCore.getInstance().getShaderpackManager();
                byte[] imageBytes = shaderpackManager.getShaderpackResourceData(imageLocation);
                ByteBuffer imageData = MemoryUtil.memAlloc((int)imageBytes.length);
                imageData.put(imageBytes).flip();
                if (imageLocation.endsWith(".bin")) {
                    this.loadBinaryImage(textureID, textureInfo, imageData);
                } else {
                    this.loadEncodedImage(textureID, textureInfo, imageData);
                }
                MemoryUtil.memFree((Buffer)imageData);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public abstract int createTexture();

        public abstract void genTextureStorage(int var1, TextureInfo var2);

        protected abstract void loadEncodedImage(int var1, TextureInfo var2, ByteBuffer var3);

        protected abstract void loadBinaryImage(int var1, TextureInfo var2, ByteBuffer var3);
    }
}

