/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.shaderpack;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import graphics.continuum.data.shaderpack.ShaderpackMetadataInfo;
import graphics.continuum.data.shaderpack.config.ShaderpackConfigInfo;
import java.util.Map;

public class ShaderpackInfo {
    private final ShaderpackMetadataInfo metadata;
    private final ShaderpackConfigInfo config;
    private final Float eyeBrightnessHalfLife;
    private final Float wetnessHalfLife;
    private final Float drynessHalfLife;
    private final Float wetness2HalfLife;
    private final Float dryness2HalfLife;
    private final Boolean flushClears;

    @JsonCreator
    public ShaderpackInfo(@JsonProperty(value="info") ShaderpackMetadataInfo metadata, @JsonProperty(value="config", required=true) ShaderpackConfigInfo config, @JsonProperty(value="eyeBrightnessHalfLife") Float eyeBrightnessHalfLife, @JsonProperty(value="wetnessHalfLife") Float wetnessHalfLife, @JsonProperty(value="drynessHalfLife") Float drynessHalfLife, @JsonProperty(value="wetness2HalfLife") Float wetness2HalfLife, @JsonProperty(value="dryness2HalfLife") Float dryness2HalfLife, @JsonProperty(value="flushClears") Boolean flushClears) {
        this.metadata = metadata;
        this.config = config;
        this.eyeBrightnessHalfLife = Float.valueOf(eyeBrightnessHalfLife == null ? 1.0f : eyeBrightnessHalfLife.floatValue());
        this.wetnessHalfLife = Float.valueOf(wetnessHalfLife == null ? 1.0f : wetnessHalfLife.floatValue());
        this.drynessHalfLife = Float.valueOf(drynessHalfLife == null ? 1.0f : drynessHalfLife.floatValue());
        this.wetness2HalfLife = wetness2HalfLife == null ? this.wetnessHalfLife : wetness2HalfLife;
        this.dryness2HalfLife = dryness2HalfLife == null ? this.drynessHalfLife : dryness2HalfLife;
        this.flushClears = flushClears == null || flushClears != false;
    }

    public ShaderpackConfigInfo getConfig() {
        return this.config;
    }

    public Map<String, String> getRedirects() {
        return this.config.getRedirects();
    }

    public String getUserConfigsPath() {
        return this.config.getUserConfig().getConfigsPath();
    }

    public String getDefaultUserConfigName() {
        return this.config.getUserConfig().getDefaultConfigName();
    }

    public ShaderpackMetadataInfo getMetadata() {
        return this.metadata;
    }

    public Float getEyeBrightnessHalfLife() {
        return this.eyeBrightnessHalfLife;
    }

    public Float getWetnessHalfLife() {
        return this.wetnessHalfLife;
    }

    public Float getDrynessHalfLife() {
        return this.drynessHalfLife;
    }

    public Boolean shouldFlushClears() {
        return this.flushClears;
    }

    public Float getWetness2HalfLife() {
        return this.wetness2HalfLife;
    }

    public Float getDryness2HalfLife() {
        return this.dryness2HalfLife;
    }
}

