/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.renderpass;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import graphics.continuum.data.renderpass.ComputeRenderPassInfo;
import graphics.continuum.data.renderpass.LegacyRenderPassInfo;
import graphics.continuum.data.renderpass.RasterRenderPassInfo;
import graphics.continuum.data.renderpass.RenderPassGroupInfo;
import java.io.IOException;
import java.util.Iterator;

@JsonDeserialize(using=Deserializer.class)
public abstract class RenderPassInfo {
    private final String name;

    protected RenderPassInfo(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public abstract Type getProgramType();

    public static class Deserializer
    extends StdNodeBasedDeserializer<RenderPassInfo> {
        protected Deserializer() {
            super(RenderPassInfo.class);
        }

        @Override
        public RenderPassInfo convert(JsonNode root, DeserializationContext ctxt) throws IOException {
            Iterator<String> fieldNames = root.fieldNames();
            if (!fieldNames.hasNext()) {
                return (RenderPassInfo)ctxt.reportInputMismatch(RenderPassInfo.class, "Failed to figure out which program type should be deserialized, empty content", new Object[0]);
            }
            Class target = null;
            String fieldName = fieldNames.next();
            if (fieldName.equals("rasterName")) {
                target = RasterRenderPassInfo.class;
            } else if (fieldName.equals("computeName")) {
                target = ComputeRenderPassInfo.class;
            } else if (fieldName.equals("legacyName")) {
                target = LegacyRenderPassInfo.class;
            } else if (fieldName.equals("groupName")) {
                target = RenderPassGroupInfo.class;
            }
            JsonParser parser = root.traverse();
            parser.nextToken();
            return ctxt.readValue(parser, target);
        }
    }

    public static enum Type {
        RASTER,
        COMPUTE,
        LEGACY,
        GROUP;

    }
}

