/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.renderpass;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphics.continuum.data.renderpass.RenderPassInfo;
import java.util.Collections;
import java.util.List;

@JsonDeserialize(using=JsonDeserializer.None.class)
public class RenderPassGroupInfo
extends RenderPassInfo {
    private final List<RenderPassInfo> passes;
    private final List<String> forcedMipmaps;
    private final int iterations;
    private final String runIfTrueValueName;
    private final boolean preFlush;
    private final boolean postFlush;

    @JsonCreator
    public RenderPassGroupInfo(@JsonProperty(value="groupName", required=true) String name, @JsonProperty(value="passes", required=true) List<RenderPassInfo> passes, @JsonProperty(value="forceMipmaps") List<String> forcedMipmaps, @JsonProperty(value="iterations") Integer iterations, @JsonProperty(value="runIfTrue") String runIfTrueValueName, @JsonProperty(value="preFlush") Boolean preFlush, @JsonProperty(value="postFlush") Boolean postFlush) {
        super(name);
        this.passes = passes;
        this.forcedMipmaps = forcedMipmaps == null ? Collections.emptyList() : forcedMipmaps;
        this.iterations = iterations != null ? iterations : 1;
        this.runIfTrueValueName = runIfTrueValueName;
        this.preFlush = preFlush != null ? preFlush : false;
        this.postFlush = postFlush != null ? postFlush : false;
    }

    @Override
    public RenderPassInfo.Type getProgramType() {
        return RenderPassInfo.Type.GROUP;
    }

    public List<RenderPassInfo> getPasses() {
        return this.passes;
    }

    public int getIterations() {
        return this.iterations;
    }

    public String getRunIfTrueValueName() {
        return this.runIfTrueValueName;
    }

    public boolean shouldPreFlush() {
        return this.preFlush;
    }

    public boolean shouldPostFlush() {
        return this.postFlush;
    }

    public List<String> getForcedMipmaps() {
        return this.forcedMipmaps;
    }
}

