/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.renderpass;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import graphics.continuum.data.renderpass.BlendState;
import graphics.continuum.data.renderpass.FramebufferBlit;
import graphics.continuum.data.renderpass.GeometryType;
import graphics.continuum.data.renderpass.RenderPassInfo;
import graphics.continuum.data.renderpass.ShaderType;
import graphics.continuum.tracking.TrackedResourceRelation;
import graphics.continuum.tracking.internal.ConstantRelation;
import graphics.continuum.tracking.internal.IntRelationDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
public class RasterRenderPassInfo
extends RenderPassInfo {
    private final GeometryType geometryType;
    private final Map<ShaderType, String> shaders;
    private final String frameBufferName;
    private final Integer iterations;
    private final TrackedResourceRelation<Integer> instances;
    private final List<String> drawBuffers;
    private final List<String> outputImages;
    private final List<String> disabledFlips;
    private final List<String> forcedFlips;
    private final Map<String, String> forcedActiveTextures;
    private final List<String> internalTextureSwaps;
    private final List<String> skippedMipmaps;
    private final List<String> forcedMipmaps;
    private final Map<String, String> copyOperations;
    private final List<BlendState> bufferBlendStates;
    private final Boolean depthTest;
    private final boolean flush;
    private final TrackedResourceRelation<Integer> viewportX;
    private final TrackedResourceRelation<Integer> viewportY;
    private final TrackedResourceRelation<Integer> viewportScaleX;
    private final TrackedResourceRelation<Integer> viewportScaleY;
    private final List<FramebufferBlit> framebufferBlits;
    private final String runIfTrueValueName;

    @Override
    public RenderPassInfo.Type getProgramType() {
        return RenderPassInfo.Type.RASTER;
    }

    @JsonCreator
    public RasterRenderPassInfo(@JsonProperty(value="rasterName", required=true) String name, @JsonProperty(value="geometryType", required=true) GeometryType geometryType, @JsonDeserialize(using=ShadersMapDeserializer.class) @JsonProperty(value="shaders", required=true) Map<ShaderType, String> shaders, @JsonProperty(value="frameBuffer") String frameBufferName, @JsonProperty(value="drawBuffers", required=true) List<String> drawBuffers, @JsonProperty(value="outputImages") List<String> outputImages, @JsonProperty(value="downscaleFactor") Integer downscaleFactor, @JsonProperty(value="iterations") Integer iterations, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="instances") TrackedResourceRelation<Integer> instances, @JsonProperty(value="disableFlips") List<String> disabledFlips, @JsonProperty(value="forceFlips") List<String> forcedFlips, @JsonProperty(value="setActiveTextures") Map<String, String> forcedActiveTextures, @JsonProperty(value="swapInternalTextures") List<String> internalTextureSwaps, @JsonProperty(value="skipMipmaps") List<String> skippedMipmaps, @JsonProperty(value="forceMipmaps") List<String> forcedMipmaps, @JsonProperty(value="copyAfter") Map<String, String> copyOperations, @JsonProperty(value="bufferBlendStates") List<BlendState> bufferBlendStates, @JsonProperty(value="depthTest") Boolean depthTest, @JsonProperty(value="flush") boolean flush, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="viewportX") TrackedResourceRelation<Integer> viewportX, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="viewportY") TrackedResourceRelation<Integer> viewportY, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="viewportScaleX") TrackedResourceRelation<Integer> viewportScaleX, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="viewportScaleY") TrackedResourceRelation<Integer> viewportScaleY, @JsonProperty(value="blitToFrameBuffer") List<FramebufferBlit> framebufferBlits, @JsonProperty(value="runIfTrue") String runIfTrueValueName) {
        super(name);
        this.shaders = shaders;
        this.geometryType = geometryType;
        this.frameBufferName = frameBufferName;
        this.drawBuffers = drawBuffers == null ? Collections.emptyList() : drawBuffers;
        this.outputImages = outputImages == null ? Collections.emptyList() : outputImages;
        this.iterations = iterations == null ? 1 : iterations;
        this.instances = instances == null ? new ConstantRelation<Integer>(1) : instances;
        this.disabledFlips = disabledFlips == null ? Collections.emptyList() : disabledFlips;
        this.forcedFlips = forcedFlips == null ? Collections.emptyList() : forcedFlips;
        this.forcedActiveTextures = forcedActiveTextures == null ? Collections.emptyMap() : forcedActiveTextures;
        this.internalTextureSwaps = internalTextureSwaps == null ? Collections.emptyList() : internalTextureSwaps;
        this.skippedMipmaps = skippedMipmaps == null ? Collections.emptyList() : skippedMipmaps;
        this.forcedMipmaps = forcedMipmaps == null ? Collections.emptyList() : forcedMipmaps;
        this.copyOperations = copyOperations == null ? Collections.emptyMap() : copyOperations;
        this.bufferBlendStates = bufferBlendStates == null ? Collections.emptyList() : bufferBlendStates;
        this.depthTest = depthTest;
        this.flush = flush;
        this.viewportX = viewportX;
        this.viewportY = viewportY;
        this.viewportScaleX = viewportScaleX;
        this.viewportScaleY = viewportScaleY;
        this.framebufferBlits = framebufferBlits == null ? Collections.emptyList() : framebufferBlits;
        this.runIfTrueValueName = runIfTrueValueName;
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    public Map<ShaderType, String> getShaders() {
        return this.shaders;
    }

    public String getFrameBufferName() {
        return this.frameBufferName;
    }

    public List<String> getDrawBuffers() {
        return this.drawBuffers;
    }

    public List<String> getOutputImages() {
        return this.outputImages;
    }

    public List<String> getDisabledFlips() {
        return this.disabledFlips;
    }

    public Map<String, String> getCopyOperations() {
        return this.copyOperations;
    }

    public List<BlendState> getBufferBlendStates() {
        return this.bufferBlendStates;
    }

    public Boolean isDepthBlend() {
        return this.depthTest;
    }

    public Integer getIterations() {
        return this.iterations;
    }

    public Integer getInstanceCount() {
        return this.instances.getValue();
    }

    public List<String> getForcedFlips() {
        return this.forcedFlips;
    }

    public List<String> getInternalTextureSwaps() {
        return this.internalTextureSwaps;
    }

    public List<String> getSkippedMipmaps() {
        return this.skippedMipmaps;
    }

    public List<String> getForcedMipmaps() {
        return this.forcedMipmaps;
    }

    public Map<String, String> getForcedActiveTextures() {
        return this.forcedActiveTextures;
    }

    public boolean getFlush() {
        return this.flush;
    }

    public TrackedResourceRelation<Integer> getViewportX() {
        return this.viewportX;
    }

    public TrackedResourceRelation<Integer> getViewportY() {
        return this.viewportY;
    }

    public List<FramebufferBlit> getFramebufferBlits() {
        return this.framebufferBlits;
    }

    public String getRunIfTrueValueName() {
        return this.runIfTrueValueName;
    }

    public TrackedResourceRelation<Integer> getViewportScaleX() {
        return this.viewportScaleX;
    }

    public TrackedResourceRelation<Integer> getViewportScaleY() {
        return this.viewportScaleY;
    }

    public static class ShadersMapDeserializer
    extends StdNodeBasedDeserializer<Map<ShaderType, String>> {
        protected ShadersMapDeserializer() {
            super(Map.class);
        }

        @Override
        public Map<ShaderType, String> convert(JsonNode root, DeserializationContext ctxt) throws IOException {
            HashMap<ShaderType, String> out = new HashMap<ShaderType, String>();
            HashMap values = new HashMap();
            root.fields().forEachRemaining(e -> {
                JsonNode cfr_ignored_0 = (JsonNode)values.put(e.getKey(), e.getValue());
            });
            for (Map.Entry field : values.entrySet()) {
                String key = (String)field.getKey();
                String value = ((JsonNode)field.getValue()).asText();
                switch (key) {
                    case "vertex": {
                        this.checkMapOnlyHas(ctxt, values, "fragment", "vertex", "geometry");
                        out.put(ShaderType.VERTEX, value);
                        break;
                    }
                    case "fragment": {
                        this.checkMapOnlyHas(ctxt, values, "fragment", "vertex", "geometry");
                        out.put(ShaderType.FRAGMENT, value);
                        break;
                    }
                    case "geometry": {
                        this.checkMapOnlyHas(ctxt, values, "fragment", "vertex", "geometry");
                        out.put(ShaderType.GEOMETRY, value);
                        break;
                    }
                    case "compute": {
                        this.checkMapOnlyHas(ctxt, values, new String[0]);
                        out.put(ShaderType.COMPUTE, value);
                        break;
                    }
                    case "rasterPack": {
                        this.checkMapOnlyHas(ctxt, values, new String[0]);
                        out.put(ShaderType.RASTER_PACK, value);
                    }
                }
            }
            if (values.containsKey("geometry")) {
                if (!values.containsKey("fragment") || !values.containsKey("vertex")) {
                    throw PropertyBindingException.from(ctxt.getParser(), out.getClass(), "A geometry shader requires a vertex and fragment shader");
                }
            } else {
                if (values.containsKey("fragment") && !values.containsKey("vertex")) {
                    throw PropertyBindingException.from(ctxt.getParser(), out.getClass(), "A fragment shader always requires a vertex shader");
                }
                if (values.containsKey("vertex") && !values.containsKey("fragment")) {
                    throw PropertyBindingException.from(ctxt.getParser(), out.getClass(), "A vertex shader always requires a fragment shader");
                }
            }
            return out;
        }

        private void checkMapOnlyHas(DeserializationContext ctxt, Map<String, ?> map, String ... values) throws MismatchedInputException {
            List<Object> listOfValues = Arrays.asList(values);
            for (String key : map.keySet()) {
                if (listOfValues.contains(key)) continue;
                throw UnrecognizedPropertyException.from(ctxt.getParser(), map, key, listOfValues);
            }
        }
    }
}

