/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.renderpass;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphics.continuum.data.renderpass.BlendState;
import graphics.continuum.data.renderpass.RenderPassInfo;
import java.util.Collections;
import java.util.List;

@JsonDeserialize(using=JsonDeserializer.None.class)
public class LegacyRenderPassInfo
extends RenderPassInfo {
    private final String renderPass;
    private final List<String> drawBuffers;
    private final List<String> disabledFlips;
    private final List<String> forcedClearsBefore;
    private final List<BlendState> bufferBlendStates;
    private final Boolean depthTest;
    private final Boolean alphaTest;

    @Override
    public RenderPassInfo.Type getProgramType() {
        return RenderPassInfo.Type.LEGACY;
    }

    @JsonCreator
    public LegacyRenderPassInfo(@JsonProperty(value="legacyName") String name, @JsonProperty(value="renderPass") String renderPass, @JsonProperty(value="drawBuffers") List<String> drawBuffers, @JsonProperty(value="disabledFlips") List<String> disabledFlips, @JsonProperty(value="forceClearBefore") List<String> forcedClearsBefore, @JsonProperty(value="bufferBlendStates") List<BlendState> bufferBlendStates, @JsonProperty(value="alphaTest") Boolean alphaTest, @JsonProperty(value="depthTest") Boolean depthTest) {
        super(name);
        this.renderPass = renderPass;
        this.drawBuffers = drawBuffers;
        this.disabledFlips = disabledFlips;
        this.forcedClearsBefore = forcedClearsBefore == null ? Collections.emptyList() : forcedClearsBefore;
        this.bufferBlendStates = bufferBlendStates == null ? Collections.emptyList() : bufferBlendStates;
        this.alphaTest = alphaTest;
        this.depthTest = depthTest;
    }

    public String getRenderPassName() {
        return this.renderPass;
    }

    public List<String> getDrawBuffers() {
        return this.drawBuffers;
    }

    public List<String> getDisabledFlips() {
        return this.disabledFlips;
    }

    public List<BlendState> getBufferBlendStates() {
        return this.bufferBlendStates;
    }

    public Boolean isAlphaTest() {
        return this.alphaTest;
    }

    public Boolean isDepthTest() {
        return this.depthTest;
    }

    public List<String> getForcedClearsBefore() {
        return this.forcedClearsBefore;
    }
}

