/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.renderpass;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphics.continuum.data.JsonUtil;

@JsonDeserialize
public class FramebufferBlit {
    private final String sourceTexture;
    private final String sourceFrameBuffer;
    private final String targetTexture;
    private final String targetFrameBuffer;
    private final int filter;

    @JsonCreator
    public FramebufferBlit(@JsonProperty(value="sourceTexture") String sourceTexture, @JsonProperty(value="sourceFrameBuffer") String sourceFrameBuffer, @JsonProperty(value="targetTexture") String targetTexture, @JsonProperty(value="targetFrameBuffer", required=true) String targetFrameBuffer, @JsonDeserialize(using=JsonUtil.OpenGLParamDeserializer.class) @JsonProperty(value="filter") int filter) {
        this.sourceTexture = sourceTexture;
        this.sourceFrameBuffer = sourceFrameBuffer;
        this.targetTexture = targetTexture;
        this.targetFrameBuffer = targetFrameBuffer;
        this.filter = filter;
        if (filter != 9729 && filter != 9728) {
            throw new IllegalStateException("Framebuffer blit filter not valid, filter must either be GL_LINEAR or GL_NEAREST!");
        }
    }

    public String getSourceTexture() {
        return this.sourceTexture;
    }

    public String getSourceFrameBuffer() {
        return this.sourceFrameBuffer;
    }

    public String getTargetFrameBuffer() {
        return this.targetFrameBuffer;
    }

    public String getTargetTexture() {
        return this.targetTexture;
    }

    public int getFilter() {
        return this.filter;
    }
}

