/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.renderpass;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.renderpass.FramebufferBlit;
import graphics.continuum.data.renderpass.RenderPassInfo;
import graphics.continuum.data.renderpass.ShaderType;
import graphics.continuum.renderer.texture.PingPongTexture;
import graphics.continuum.tracking.TrackedResourceRelation;
import graphics.continuum.tracking.internal.ConstantRelation;
import graphics.continuum.tracking.internal.IntRelationDeserializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
public class ComputeRenderPassInfo
extends RenderPassInfo {
    private final Map<ShaderType, String> shaders = new HashMap<ShaderType, String>();
    private final Integer dispatchGroupsX;
    private final Integer dispatchGroupsY;
    private final Integer dispatchGroupsZ;
    private final TrackedResourceRelation<Integer> dispatchResolutionX;
    private final TrackedResourceRelation<Integer> dispatchResolutionY;
    private final TrackedResourceRelation<Integer> dispatchResolutionZ;
    private final Integer localGroupX;
    private final Integer localGroupY;
    private final Integer localGroupZ;
    private final String dispatchIndirectBuffer;
    private final Boolean executeMipchain;
    private final Integer syncExecutions;
    private final Integer iterations;
    private final Integer downscaleFactor;
    private final Float downscaleFactorX;
    private final Float downscaleFactorY;
    private final Float downscaleFactorZ;
    private final List<String> outputImages;
    private final List<String> disabledFlips;
    private final List<String> forcedFlips;
    private final Map<String, String> forcedActiveTextures;
    private final List<String> internalTextureSwaps;
    private final List<String> residentHandles;
    private final List<String> skippedMipmaps;
    private final List<String> forcedMipmaps;
    private final boolean flush;
    private final List<FramebufferBlit> framebufferBlits;
    private final List<Integer> memoryBarriers;
    private final String runIfTrueValueName;

    @Override
    public RenderPassInfo.Type getProgramType() {
        return RenderPassInfo.Type.COMPUTE;
    }

    @JsonCreator
    public ComputeRenderPassInfo(@JsonProperty(value="computeName", required=true) String name, @JsonProperty(value="shaders", required=true) Map<String, String> shaders, @JsonProperty(value="outputImages") List<String> outputImages, @JsonProperty(value="downscaleFactor") Integer downscaleFactor, @JsonProperty(value="downscaleFactorX") Float downscaleFactorX, @JsonProperty(value="downscaleFactorY") Float downscaleFactorY, @JsonProperty(value="downscaleFactorZ") Float downscaleFactorZ, @JsonProperty(value="dispatchGroupsX") Integer dispatchGroupsX, @JsonProperty(value="dispatchGroupsY") Integer dispatchGroupsY, @JsonProperty(value="dispatchGroupsZ") Integer dispatchGroupsZ, @JsonProperty(value="localGroupX") Integer localGroupX, @JsonProperty(value="localGroupY") Integer localGroupY, @JsonProperty(value="localGroupZ") Integer localGroupZ, @JsonProperty(value="dispatchIndirectBuffer") String dispatchIndirectBuffer, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="dispatchResolutionX") TrackedResourceRelation<Integer> dispatchResolutionX, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="dispatchResolutionY") TrackedResourceRelation<Integer> dispatchResolutionY, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="dispatchResolutionZ") TrackedResourceRelation<Integer> dispatchResolutionZ, @JsonProperty(value="iterations") Integer iterations, @JsonProperty(value="executeMipchain") Boolean executeMipchain, @JsonProperty(value="syncExecutions") Integer syncExecutions, @JsonProperty(value="disableFlips") List<String> disabledFlips, @JsonProperty(value="forceFlips") List<String> forcedFlips, @JsonProperty(value="setActiveTextures") Map<String, String> forcedActiveTextures, @JsonProperty(value="swapInternalTextures") List<String> internalTextureSwaps, @JsonProperty(value="residentHandles") List<String> residentHandles, @JsonProperty(value="skipMipmaps") List<String> skippedMipmaps, @JsonProperty(value="forceMipmaps") List<String> forcedMipmaps, @JsonProperty(value="copyAfter") Map<String, String> copyOperations, @JsonProperty(value="flush") boolean flush, @JsonProperty(value="blitToFrameBuffer") List<FramebufferBlit> framebufferBlits, @JsonProperty(value="memoryBarriers") List<String> memoryBarriers, @JsonProperty(value="runIfTrue") String runIfTrueValueName) {
        super(name);
        shaders.values().forEach(shader -> this.shaders.put(ShaderType.COMPUTE, (String)shader));
        this.dispatchGroupsX = dispatchGroupsX;
        this.dispatchGroupsY = dispatchGroupsY;
        this.dispatchGroupsZ = dispatchGroupsZ;
        this.localGroupX = localGroupX;
        this.localGroupY = localGroupY;
        this.localGroupZ = localGroupZ;
        this.dispatchResolutionX = dispatchResolutionX == null ? new ConstantRelation<Integer>(0) : dispatchResolutionX;
        this.dispatchResolutionY = dispatchResolutionY == null ? new ConstantRelation<Integer>(0) : dispatchResolutionY;
        this.dispatchResolutionZ = dispatchResolutionZ == null ? new ConstantRelation<Integer>(0) : dispatchResolutionZ;
        this.downscaleFactor = downscaleFactor == null ? 1 : downscaleFactor;
        this.downscaleFactorX = Float.valueOf(downscaleFactorX == null ? (downscaleFactor == null ? -1.0f : (float)downscaleFactor.intValue()) : downscaleFactorX.floatValue());
        this.downscaleFactorY = Float.valueOf(downscaleFactorY == null ? (downscaleFactor == null ? -1.0f : (float)downscaleFactor.intValue()) : downscaleFactorY.floatValue());
        this.downscaleFactorZ = Float.valueOf(downscaleFactorZ == null ? (downscaleFactor == null ? -1.0f : (float)downscaleFactor.intValue()) : downscaleFactorZ.floatValue());
        this.dispatchIndirectBuffer = dispatchIndirectBuffer;
        this.executeMipchain = executeMipchain;
        this.syncExecutions = syncExecutions == null ? 1 : syncExecutions;
        this.outputImages = outputImages == null ? Collections.emptyList() : this.removeTextureSuffix(outputImages);
        this.disabledFlips = disabledFlips == null ? Collections.emptyList() : disabledFlips;
        this.forcedFlips = forcedFlips == null ? Collections.emptyList() : forcedFlips;
        this.forcedActiveTextures = forcedActiveTextures == null ? Collections.emptyMap() : forcedActiveTextures;
        this.internalTextureSwaps = internalTextureSwaps == null ? Collections.emptyList() : internalTextureSwaps;
        this.residentHandles = residentHandles == null ? Collections.emptyList() : residentHandles;
        this.skippedMipmaps = skippedMipmaps == null ? Collections.emptyList() : skippedMipmaps;
        this.forcedMipmaps = forcedMipmaps == null ? Collections.emptyList() : forcedMipmaps;
        this.iterations = iterations == null ? 1 : iterations;
        this.flush = flush;
        this.framebufferBlits = framebufferBlits == null ? Collections.emptyList() : framebufferBlits;
        this.memoryBarriers = new ArrayList<Integer>();
        if (memoryBarriers != null) {
            memoryBarriers.forEach(barrier -> {
                if (!JsonUtil.OPEN_GL_FIELD_MAPPINGS.containsKey(barrier)) {
                    throw new IllegalStateException(barrier + " is not a valid OpenGL constant");
                }
                this.memoryBarriers.add(JsonUtil.OPEN_GL_FIELD_MAPPINGS.get(barrier));
            });
        } else {
            this.memoryBarriers.add(-1);
        }
        this.runIfTrueValueName = runIfTrueValueName;
    }

    public Map<ShaderType, String> getShaders() {
        return this.shaders;
    }

    public Integer getDispatchGroupsX() {
        return this.dispatchGroupsX;
    }

    public Integer getDispatchGroupsY() {
        return this.dispatchGroupsY;
    }

    public Integer getDispatchGroupsZ() {
        return this.dispatchGroupsZ;
    }

    public Integer getDispatchResolutionX() {
        return this.downscaleFactorX.floatValue() > 0.0f ? Integer.valueOf((int)Math.ceil((float)this.dispatchResolutionX.getValue().intValue() / this.downscaleFactorX.floatValue())) : this.dispatchResolutionX.getValue();
    }

    public Integer getDispatchResolutionY() {
        return this.downscaleFactorY.floatValue() > 0.0f ? Integer.valueOf((int)Math.ceil((float)this.dispatchResolutionY.getValue().intValue() / this.downscaleFactorY.floatValue())) : this.dispatchResolutionY.getValue();
    }

    public Integer getDispatchResolutionZ() {
        return this.downscaleFactorZ.floatValue() > 0.0f ? Integer.valueOf((int)Math.ceil((float)this.dispatchResolutionZ.getValue().intValue() / this.downscaleFactorZ.floatValue())) : this.dispatchResolutionZ.getValue();
    }

    public Integer getLocalGroupX() {
        return this.localGroupX;
    }

    public Integer getLocalGroupY() {
        return this.localGroupY;
    }

    public Integer getLocalGroupZ() {
        return this.localGroupZ;
    }

    public String getDispatchIndirectBuffer() {
        return this.dispatchIndirectBuffer;
    }

    public boolean requiresUpdate() {
        return this.dispatchResolutionX.requiresUpdate() || this.dispatchResolutionY.requiresUpdate() || this.dispatchResolutionZ.requiresUpdate();
    }

    public Integer getIterations() {
        if (this.executeMipchain != null && this.executeMipchain.booleanValue()) {
            int realWidth = this.dispatchResolutionX.getValue();
            int realHeight = this.dispatchResolutionY.getValue();
            long largestDimension = Math.max(realWidth, realHeight);
            double logSize = Math.log(largestDimension) / Math.log(2.0);
            return 1 + (int)Math.floor(logSize);
        }
        return this.iterations;
    }

    public Boolean shouldExecuteMipchain() {
        return this.executeMipchain != null && this.executeMipchain != false;
    }

    public Integer getSyncExecutions() {
        return this.syncExecutions;
    }

    public Float getDownscaleFactor() {
        return Float.valueOf(this.downscaleFactor > 0 ? (float)this.downscaleFactor.intValue() : 1.0f);
    }

    public Float getDownscaleFactorX() {
        return Float.valueOf(this.downscaleFactorX.floatValue() > 0.0f ? this.downscaleFactorX.floatValue() : 1.0f);
    }

    public Float getDownscaleFactorY() {
        return Float.valueOf(this.downscaleFactorY.floatValue() > 0.0f ? this.downscaleFactorY.floatValue() : 1.0f);
    }

    public Float getDownscaleFactorZ() {
        return Float.valueOf(this.downscaleFactorZ.floatValue() > 0.0f ? this.downscaleFactorZ.floatValue() : 1.0f);
    }

    private List<String> removeTextureSuffix(List<String> images) {
        images.replaceAll(PingPongTexture.ABInternalTexture::removeInternalTextureSuffix);
        return images;
    }

    public List<String> getOutputImages() {
        return this.outputImages;
    }

    public List<String> getDisabledFlips() {
        return this.disabledFlips;
    }

    public List<String> getForcedFlips() {
        return this.forcedFlips;
    }

    public List<String> getInternalTextureSwaps() {
        return this.internalTextureSwaps;
    }

    public List<String> getSkippedMipmaps() {
        return this.skippedMipmaps;
    }

    public List<String> getForcedMipmaps() {
        return this.forcedMipmaps;
    }

    public Map<String, String> getForcedActiveTextures() {
        return this.forcedActiveTextures;
    }

    public List<String> getResidentHandles() {
        return this.residentHandles;
    }

    public boolean getFlush() {
        return this.flush;
    }

    public List<FramebufferBlit> getFramebufferBlits() {
        return this.framebufferBlits;
    }

    public List<Integer> getMemoryBarriers() {
        return this.memoryBarriers;
    }

    public String getRunIfTrueValueName() {
        return this.runIfTrueValueName;
    }
}

