/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.renderpass;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphics.continuum.data.JsonUtil;
import org.lwjgl.opengl.GL46C;

@JsonDeserialize
public class BlendState {
    public final String textureName;
    public final boolean disabled;
    public final int sfactor;
    public final int dfactor;
    public final int equation;

    @JsonCreator
    public BlendState(@JsonProperty(value="buffer", required=true) String textureName, @JsonProperty(value="disabled") boolean disabled, @JsonDeserialize(using=JsonUtil.OpenGLParamDeserializer.class) @JsonProperty(value="sfactor") Integer sfactor, @JsonDeserialize(using=JsonUtil.OpenGLParamDeserializer.class) @JsonProperty(value="dfactor") Integer dfactor, @JsonDeserialize(using=JsonUtil.OpenGLParamDeserializer.class) @JsonProperty(value="equation") Integer equation) {
        this.textureName = textureName;
        this.disabled = disabled;
        this.sfactor = sfactor == null ? 1 : sfactor;
        this.dfactor = dfactor == null ? 0 : dfactor;
        this.equation = equation == null ? -1 : equation;
    }

    public void updateBlendState(int attachment) {
        if (this.disabled) {
            GL46C.glDisablei((int)3042, (int)attachment);
        } else {
            GL46C.glBlendFunci((int)attachment, (int)this.sfactor, (int)this.dfactor);
            if (this.equation != -1) {
                GL46C.glBlendEquationi((int)attachment, (int)this.equation);
            }
        }
    }
}

