/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.framebuffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphics.continuum.tracking.TrackedResourceRelation;
import graphics.continuum.tracking.internal.IntRelationDeserializer;

public class FrameBufferInfo {
    private final String name;
    private final boolean defaultFBO;
    private final boolean minecraftFBO;
    private final String colorAttachment;
    private final String depthAttachment;
    private final String legacyDepthAttachment;
    private final TrackedResourceRelation<Integer> width;
    private final TrackedResourceRelation<Integer> height;
    private final Float downscaleFactor;

    @JsonCreator
    public FrameBufferInfo(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="default") boolean defaultFBO, @JsonProperty(value="minecraftFBO") boolean minecraftFBO, @JsonProperty(value="outputColorAttachment") String colorAttachment, @JsonProperty(value="defaultDepthAttachment") String depthAttachment, @JsonProperty(value="legacyDepthAttachment") String legacyDepthAttachment, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="width", required=true) TrackedResourceRelation<Integer> width, @JsonDeserialize(using=IntRelationDeserializer.class) @JsonProperty(value="height", required=true) TrackedResourceRelation<Integer> height, @JsonProperty(value="downscaleFactor") Float downscaleFactor) {
        this.name = name;
        this.defaultFBO = defaultFBO;
        this.minecraftFBO = minecraftFBO;
        this.colorAttachment = colorAttachment;
        this.depthAttachment = depthAttachment;
        this.legacyDepthAttachment = legacyDepthAttachment;
        this.width = width;
        this.height = height;
        this.downscaleFactor = Float.valueOf(downscaleFactor != null ? downscaleFactor.floatValue() : -1.0f);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultFBO() {
        return this.defaultFBO;
    }

    public String getDepthAttachment() {
        return this.depthAttachment;
    }

    public TrackedResourceRelation<Integer> getWidth() {
        return this.width;
    }

    public TrackedResourceRelation<Integer> getHeight() {
        return this.height;
    }

    public String getLegacyDepthAttachment() {
        return this.legacyDepthAttachment;
    }

    public String getColorAttachment() {
        return this.colorAttachment;
    }

    public boolean isMinecraftFBO() {
        return this.minecraftFBO;
    }

    public Float getDownscaleFactor() {
        return this.downscaleFactor;
    }
}

