/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.copp;

import graphics.continuum.data.copp.ContinuumProduct;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.data.copp.StratumResolution;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum ContinuumProductType {
    ALL("All", "All Products", "", "", "", null),
    CONTINUUM_PUBLIC_RELEASE("Continuum Public Release", "Continuum", "focal/shaderpacks/", ".downloading", ".bin", new String[]{"All public Continuum shader packs."}){

        @Override
        public String getDownloadPath(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName + this.downloadExtension;
            }
            return "shaderpacks/" + productItem.itemName + this.downloadExtension;
        }

        @Override
        public String getDownloadPathNoExt(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName;
            }
            return "shaderpacks/" + productItem.itemName;
        }

        @Override
        public String getInstallPath(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName + this.installExtension;
            }
            return "shaderpacks/" + productItem.itemName + ".zip";
        }

        @Override
        public String getInstallPathNoExt(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName;
            }
            return "shaderpacks/" + productItem.itemName;
        }
    }
    ,
    CONTINUUM_EARLY_ACCESS("Continuum Early Access", "Continuum EA", "focal/shaderpacks/", ".downloading", ".bin", new String[]{"Early Access downloads for non-Ray Traced versions of our in-development Continuum Shaders.", "These versions may exhibit visual bugs or unexpected behavior. You can report bugs, leave feedback and request help in the relevant channel in our official Discord server, or via the contact form on our site."}){

        @Override
        public String getDownloadPath(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName + this.downloadExtension;
            }
            return "shaderpacks/" + productItem.itemName + this.downloadExtension;
        }

        @Override
        public String getDownloadPathNoExt(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName;
            }
            return "shaderpacks/" + productItem.itemName;
        }

        @Override
        public String getInstallPath(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName + this.installExtension;
            }
            return "shaderpacks/" + productItem.itemName + ".zip";
        }

        @Override
        public String getInstallPathNoExt(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName;
            }
            return "shaderpacks/" + productItem.itemName;
        }

        @Override
        public String getTruncatedDisplayVersionID(ContinuumProductItem productItem) {
            return Integer.toString(productItem.versionID);
        }

        @Override
        public List<String> getVersions(ContinuumProduct product) {
            return product.getAllProjects();
        }

        @Override
        public List<ContinuumProductItem> getItems(ContinuumProduct product) {
            ArrayList<ContinuumProductItem> items = new ArrayList<ContinuumProductItem>();
            for (ContinuumProductItem item : product.getAllItems()) {
                if (!item.project.equalsIgnoreCase(product.getSelectedProject())) continue;
                items.add(item);
            }
            return items;
        }
    }
    ,
    CONTINUUM_RT("Continuum RT", "Continuum RT", "focal/shaderpacks/", ".downloading", ".bin", new String[]{"Downloads for the fully Ray Traced version of our in-development Continuum RT shaderpack.", "This shader is currently in an Early Alpha state, is extremely performance intensive and has some specific setting configuration requirements as well. Please see the System Requirements page on our site for hardware requirements, settings requirements and a list of the most notable current known issues."}){

        @Override
        public String getDownloadPath(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName + this.downloadExtension;
            }
            return "shaderpacks/" + productItem.itemName + this.downloadExtension;
        }

        @Override
        public String getDownloadPathNoExt(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName;
            }
            return "shaderpacks/" + productItem.itemName;
        }

        @Override
        public String getInstallPath(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName + this.installExtension;
            }
            return "shaderpacks/" + productItem.itemName + ".zip";
        }

        @Override
        public String getInstallPathNoExt(ContinuumProductItem productItem) {
            if (productItem.isFocal) {
                return this.downloadPath + productItem.itemName;
            }
            return "shaderpacks/" + productItem.itemName;
        }

        @Override
        public String getTruncatedDisplayVersionID(ContinuumProductItem productItem) {
            return Integer.toString(productItem.versionID);
        }
    }
    ,
    STRATUM("Stratum", "Stratum", "resourcepacks/", ".downloading", ".zip", new String[]{"Stratum is a realistic, high resolution and high quality resourcepack for Minecraft, built with shader compatibility in mind. It supports many high end shader effects,. Including Parallax Occlusion Mapping; which provides a new layer of depth to surfaces in game. As well as high quality normal and specular maps. Stratum also uses fully Physically Based materials, just like many AAA titles do today.", "Stratum is being built specifically with our Continuum series of Minecraft shaderpacks in mind. With that said, it should work well with a variety of other Minecraft shaders. It should also run on a variety of systems. More modest gaming rigs can choose one of the lower resolution options, such as 256x, or maybe 512x. Higher end systems can go with 1024x. The highest end systems of the future can use the full 2048x pack.", "For now, the pack is only going to cover the base Minecraft textures, but in the future there will likely be add-on modules for mods, such as Better Foliage, or even Buildcraft. That said, as it is still currently being developed, the focus is only on finishing the base Minecraft textures for now."}){

        @Override
        public boolean compareProductNames(String otherName) {
            return !otherName.toLowerCase().contains("leaves") && otherName.startsWith(this.productName);
        }

        @Override
        public List<StratumResolution> getResolutions(ContinuumProduct product) {
            ArrayList<StratumResolution> resolutions = new ArrayList<StratumResolution>();
            product.getAllResolutions().forEach(resolution -> {
                boolean isAccessible = product.getAvailableResolutions().contains(resolution);
                resolutions.add(new StratumResolution((int)resolution, isAccessible));
            });
            return resolutions;
        }

        @Override
        public List<ContinuumProductItem> getItems(ContinuumProduct product) {
            String clientVersion = FocalEngineGameInterface.getGameVersion();
            ArrayList<ContinuumProductItem> versions = new ArrayList<ContinuumProductItem>();
            for (ContinuumProductItem productItem : product.getAllItems()) {
                String supportedGameVersion = productItem.supportedGameVersion;
                if (!productItem.isAccessible || Integer.parseInt(productItem.resolution.replace("x", "")) != product.getSelectedResolution() || (!supportedGameVersion.startsWith("1.13") || StringUtil.compareStringVersions(clientVersion, supportedGameVersion) < 0) && (!supportedGameVersion.startsWith("1.12") || StringUtil.compareStringVersions(clientVersion, supportedGameVersion) > 0)) continue;
                versions.add(productItem);
            }
            return versions;
        }
    }
    ,
    STRATUM_FAST_LEAVES("Stratum Fast Leaves", "Stratum Performance Leaves", "resourcepacks/", ".downloading", ".zip", new String[]{"An alternative leaves model to help with performance when using the Stratum resource pack."}){};

    protected final String displayName;
    protected final String productName;
    protected final String downloadPath;
    protected final String downloadExtension;
    protected final String installExtension;
    protected final List<String> description;

    private ContinuumProductType(String displayName, String productFamilyName, String downloadPath, String downloadExtension, String installExtension, String[] description) {
        this.displayName = displayName;
        this.productName = productFamilyName;
        this.downloadPath = downloadPath;
        this.downloadExtension = downloadExtension;
        this.installExtension = installExtension;
        this.description = description != null ? Arrays.asList(description) : Collections.emptyList();
    }

    public static ContinuumProductType getTypeOf(String productFamilyName) {
        for (ContinuumProductType productType : ContinuumProductType.values()) {
            if (productType == ALL || !productType.compareProductNames(productFamilyName)) continue;
            return productType;
        }
        return null;
    }

    public boolean compareProductNames(String otherName) {
        return otherName.equals(this.productName);
    }

    public List<ContinuumProductItem> getItems(ContinuumProduct product) {
        return product.getAllItems();
    }

    public List<StratumResolution> getResolutions(ContinuumProduct product) {
        return new ArrayList<StratumResolution>();
    }

    public List<String> getVersions(ContinuumProduct product) {
        return new ArrayList<String>();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getTruncatedDisplayVersionID(ContinuumProductItem productItem) {
        return productItem.displayedVersionID;
    }

    public String getDownloadPath(ContinuumProductItem productItem) {
        return this.downloadPath + productItem.itemName + this.downloadExtension;
    }

    public String getDownloadPathNoExt(ContinuumProductItem productItem) {
        return this.downloadPath + productItem.itemName;
    }

    public String getInstallPath(ContinuumProductItem productItem) {
        return this.downloadPath + productItem.itemName + this.installExtension;
    }

    public String getInstallPathNoExt(ContinuumProductItem productItem) {
        return this.downloadPath + productItem.itemName;
    }

    public String getDownloadPathExtension(ContinuumProductItem productItem) {
        return this.downloadExtension;
    }

    public List<String> getDescription() {
        return this.description;
    }
}

