/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.copp;

import graphics.continuum.data.copp.ContinuumProduct;
import graphics.continuum.data.copp.models.COPPDownload;
import java.time.LocalDateTime;

public class ContinuumProductItem
implements Comparable<ContinuumProductItem> {
    public final ContinuumProduct product;
    public final String itemName;
    public final String productName;
    public final String description;
    public final int versionID;
    public final String displayedVersionID;
    public final String resolution;
    public final String project;
    public final String supportedGameVersion;
    public final boolean isAccessible;
    public final int downloadID;
    public final boolean isFocal;
    public final LocalDateTime releaseDate;

    public ContinuumProductItem(ContinuumProduct product, COPPDownload downloadInfo) {
        this.product = product;
        this.itemName = downloadInfo.displayName;
        this.description = downloadInfo.description;
        this.versionID = downloadInfo.versionId;
        this.resolution = downloadInfo.resolution;
        this.isAccessible = downloadInfo.isAccessible;
        this.downloadID = downloadInfo.downloadId;
        this.isFocal = downloadInfo.isFocal;
        this.project = downloadInfo.project;
        this.releaseDate = downloadInfo.releaseDate;
        String productName = downloadInfo.productFamily;
        String supportedGameVersion = null;
        if (productName.equalsIgnoreCase("stratum performance leaves")) {
            productName = "Stratum Fast Leaves";
        } else if (productName.toLowerCase().contains("stratum")) {
            supportedGameVersion = productName.split("\\(")[1].split("\\)")[0];
            productName = "Stratum";
        }
        this.productName = productName;
        this.supportedGameVersion = supportedGameVersion;
        String displayedVersionId = "Build " + this.versionID;
        if (this.productName.equalsIgnoreCase("continuum")) {
            displayedVersionId = this.itemName.toLowerCase().replace("continuum ", "");
        }
        this.displayedVersionID = displayedVersionId;
    }

    @Override
    public int compareTo(ContinuumProductItem o) {
        int intComparison = Integer.compare(this.versionID, o.versionID);
        return intComparison != 0 ? intComparison : this.displayedVersionID.compareTo(o.displayedVersionID);
    }

    public String toString() {
        return this.displayedVersionID;
    }
}

