/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data.copp;

import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ContinuumProduct
implements Comparable<ContinuumProduct> {
    private final List<ContinuumProductItem> allItems;
    private final List<ContinuumProductItem> accessibleItems;
    private final ContinuumProductType productType;
    private int maxListWidth;
    private int totalAvailableBuilds;
    private int accessibleBuilds;
    private int inaccessibleBuilds;
    private final List<Integer> allResolutions = new ArrayList<Integer>();
    private final List<Integer> availableResolutions = new ArrayList<Integer>();
    private final List<String> allProjects = new ArrayList<String>();
    private String selectedProject;
    private int maxResolution;
    private int selectedResolution;

    public ContinuumProduct(ContinuumProductType productType) {
        this.allItems = new ArrayList<ContinuumProductItem>();
        this.accessibleItems = new ArrayList<ContinuumProductItem>();
        this.productType = productType;
    }

    public void populateFamilyMetadata() {
        this.totalAvailableBuilds = this.allItems.size();
        this.inaccessibleBuilds = this.filterItems(item -> !item.isAccessible).size();
        this.accessibleBuilds = this.totalAvailableBuilds - this.inaccessibleBuilds;
        ArrayList<String> displayedListContents = new ArrayList<String>();
        assert (this.productType != null);
        displayedListContents.add(this.productType.getDisplayName());
        this.maxListWidth = 0;
        for (String line : displayedListContents) {
            this.maxListWidth = Math.max(this.maxListWidth, FocalEngineGameInterface.getFontWidth(line));
        }
    }

    public void addItem(ContinuumProductItem item) {
        if (item.productName.equalsIgnoreCase("stratum")) {
            int itemResolution = Integer.parseInt(item.resolution.replace("x", ""));
            if (item.isAccessible) {
                this.maxResolution = this.maxResolution == 0 ? itemResolution : Math.max(this.maxResolution, itemResolution);
                if (!this.availableResolutions.contains(itemResolution)) {
                    this.availableResolutions.add(itemResolution);
                }
            }
            if (!this.allResolutions.contains(itemResolution)) {
                this.allResolutions.add(itemResolution);
            }
        }
        if (item.project != null && !this.allProjects.contains(item.project)) {
            this.allProjects.add(item.project);
        }
        this.allItems.add(item);
        if (item.isAccessible) {
            this.accessibleItems.add(item);
        }
    }

    public List<ContinuumProductItem> filterItems(Predicate<ContinuumProductItem> filter) {
        ArrayList<ContinuumProductItem> newItemList = new ArrayList<ContinuumProductItem>(this.allItems);
        newItemList.removeIf(filter.negate());
        return newItemList;
    }

    @Override
    public int compareTo(ContinuumProduct o) {
        return this.productType.compareTo(o.productType);
    }

    public List<ContinuumProductItem> getAllItems() {
        return this.allItems;
    }

    public List<ContinuumProductItem> getAccessibleItems() {
        return this.accessibleItems;
    }

    public ContinuumProductType getProductType() {
        return this.productType;
    }

    public int getMaxResolution() {
        return this.maxResolution;
    }

    public int getAccessibleBuilds() {
        return this.accessibleBuilds;
    }

    public int getInaccessibleBuilds() {
        return this.inaccessibleBuilds;
    }

    public int getMaxListWidth() {
        return this.maxListWidth;
    }

    public List<Integer> getAllResolutions() {
        return this.allResolutions;
    }

    public List<Integer> getAvailableResolutions() {
        return this.availableResolutions;
    }

    public int getSelectedResolution() {
        return this.selectedResolution;
    }

    public void selectResolution(int resolution) {
        this.selectedResolution = resolution;
    }

    public List<String> getAllProjects() {
        return this.allProjects;
    }

    public String getSelectedProject() {
        return this.selectedProject;
    }

    public void selectProject(String project) {
        this.selectedProject = project;
    }
}

