/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.data;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL46C;

public class JsonUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static final Map<String, Integer> OPEN_GL_FIELD_MAPPINGS = new HashMap<String, Integer>();
    private static final Map<Integer, String> OPEN_GL_FIELD_MAPPINGS_BIMAP = new HashMap<Integer, String>();

    private JsonUtil() {
    }

    public static String getGLFieldFromValue(int value) {
        return OPEN_GL_FIELD_MAPPINGS_BIMAP.get(value);
    }

    public static <T> T readValue(Class<T> target, JsonNode root, DeserializationContext ctxt) throws IOException {
        JavaType type = ctxt.getTypeFactory().constructType(target);
        JsonDeserializer<Object> deserializer = ctxt.findRootValueDeserializer(type);
        JsonParser parser = root.traverse(ctxt.getParser().getCodec());
        parser.nextToken();
        return (T)deserializer.deserialize(parser, ctxt);
    }

    static {
        Class currentTarget = GL46C.class;
        do {
            for (Field field : currentTarget.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Integer.TYPE)) continue;
                try {
                    OPEN_GL_FIELD_MAPPINGS.put(field.getName(), field.getInt(null));
                    OPEN_GL_FIELD_MAPPINGS_BIMAP.put(field.getInt(null), field.getName());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to initialize OpenGL mappings", e);
                }
            }
        } while ((currentTarget = currentTarget.getSuperclass()) != Object.class);
        MAPPER.registerModule(new SimpleModule().addSerializer(LocalDateTime.class, new LocalDateTimeSerializer()).addDeserializer(LocalDateTime.class, new LocalDateTimeDeserializer()));
    }

    public static class LocalDateTimeSerializer
    extends StdSerializer<LocalDateTime> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

        public LocalDateTimeSerializer() {
            super(LocalDateTime.class);
        }

        @Override
        public void serialize(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(FORMATTER.format(localDateTime));
        }
    }

    public static class LocalDateTimeDeserializer
    extends StdDeserializer<LocalDateTime> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

        public LocalDateTimeDeserializer() {
            super(LocalDateTime.class);
        }

        @Override
        public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return LocalDateTime.parse(parser.getText(), FORMATTER);
        }
    }

    public static class OpenGLParamDeserializer
    extends FromStringDeserializer<Integer> {
        protected OpenGLParamDeserializer() {
            super(Integer.class);
        }

        @Override
        protected Integer _deserialize(String value, DeserializationContext ctxt) throws IOException {
            if (!OPEN_GL_FIELD_MAPPINGS.containsKey(value)) {
                throw JsonMappingException.from(ctxt.getParser(), value + " is not a valid OpenGL constant");
            }
            return OPEN_GL_FIELD_MAPPINGS.get(value);
        }
    }

    public static class OpenGLParamKeyDeserializer
    extends KeyDeserializer {
        private final OpenGLParamDeserializer delegate = new OpenGLParamDeserializer();

        protected OpenGLParamKeyDeserializer() {
        }

        @Override
        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            return this.delegate._deserialize(key, ctxt);
        }
    }
}

