/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.common.mixin;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class OptifineDetectMixinConfig
implements IMixinConfigPlugin {
    private String optifineVersion;

    public void onLoad(String mixinPackage) {
        try {
            Class<?> optifineInstallerClass = Class.forName("optifine.Installer");
            Method getVersionHandler = optifineInstallerClass.getMethod("getOptiFineVersion", new Class[0]);
            this.optifineVersion = (String)getVersionHandler.invoke(null, new Object[0]);
            this.optifineVersion = this.optifineVersion.replace("_pre", "");
            this.optifineVersion = this.optifineVersion.substring(this.optifineVersion.length() - 2);
            System.out.println("Detected Optifine version: " + this.optifineVersion);
        }
        catch (ClassNotFoundException e) {
            this.optifineVersion = null;
            System.out.println("No Optifine detected");
        }
        catch (Exception e) {
            System.out.println("Optifine detected, but could not detect version. It may not work. Assuming Optifine E1...");
            e.printStackTrace();
            this.optifineVersion = "??";
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.toLowerCase(Locale.ROOT).contains("optifine")) {
            return this.optifineVersion != null;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

