/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum;

import graphics.continuum.data.copp.models.responses.impl.COPPLoginResponse;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.network.ContinuumAccount;
import graphics.continuum.product.DownloadManager;
import graphics.continuum.product.ProductManager;
import graphics.continuum.renderer.framebuffer.FrameBufferManager;
import graphics.continuum.renderer.renderpass.RenderPassManager;
import graphics.continuum.renderer.shaderstorage.ShaderStorageManager;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.uniform.UniformManager;
import graphics.continuum.renderer.vertex.VertexManager;
import graphics.continuum.shaderpack.ShaderpackManager;
import graphics.continuum.tracking.TrackedResources;
import graphics.continuum.util.Pair;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FocalEngineCore {
    private static FocalEngineCore instance;
    private final Logger logger;
    private ContinuumAccount account;
    private final Thread accountLoadThread;
    private final ShaderpackManager shaderpackManager;
    private final ProductManager productManager;
    private final DownloadManager downloadManager;
    private final FocalEngineGameInterface gameInterface;
    private boolean hasShownStartupToasts;
    public static boolean GL_DEBUG_GROUPS;

    private FocalEngineCore(FocalEngineGameInterface gameInterface) {
        instance = this;
        this.gameInterface = gameInterface;
        this.logger = LogManager.getLogger((String)"FocalEngine");
        this.downloadManager = new DownloadManager();
        this.productManager = new ProductManager();
        this.accountLoadThread = new Thread(() -> {
            this.logger.info("Attempting to load the locally saved Continuum Graphics account...");
            this.account = ContinuumAccount.loadAccountJson();
            if (this.account != null) {
                this.logger.info("Successfully loaded locally saved Continuum Graphics account!");
                if (this.account.getAccessTokenExpiryDate().compareTo(new Date()) <= 0) {
                    this.logger.info("Locally saved Continuum Graphics account has an outdated access token.");
                    this.account.refreshAccessToken();
                }
                this.account.refreshDownloadsList(false);
                this.productManager.sortDownloads(this.account.getDownloads());
            } else {
                this.account = ContinuumAccount.createAdhocAccount();
            }
        }, "Account Load Thread");
        this.accountLoadThread.start();
        this.shaderpackManager = new ShaderpackManager();
    }

    public ShaderpackManager getShaderpackManager() {
        return this.shaderpackManager;
    }

    public FrameBufferManager getFrameBufferManager() {
        return this.shaderpackManager.getFrameBufferManager();
    }

    public TextureManager getTextureManager() {
        return this.shaderpackManager.getTextureManager();
    }

    public RenderPassManager getRenderPassManager() {
        return this.shaderpackManager.getRenderPassManager();
    }

    public UniformManager getUniformManager() {
        return this.shaderpackManager.getUniformManager();
    }

    public VertexManager getVertexManager() {
        return this.shaderpackManager.getVertexManager();
    }

    public ShaderStorageManager getShaderStorageManager() {
        return this.shaderpackManager.getShaderStorageManager();
    }

    public TrackedResources getTrackedResources() {
        return this.shaderpackManager.getTrackedResources();
    }

    public ContinuumAccount getAccount() {
        return this.account;
    }

    public boolean hasAccount() {
        return this.account != null;
    }

    public FocalEngineGameInterface getGameInterface() {
        return this.gameInterface;
    }

    public COPPLoginResponse attemptLogin(String username, String password) throws IOException, URISyntaxException {
        Pair<ContinuumAccount, COPPLoginResponse> loginAttempt = ContinuumAccount.login(username, password);
        COPPLoginResponse coppLoginResponse = loginAttempt.getB();
        if (coppLoginResponse.isSuccess()) {
            this.account = loginAttempt.getA();
            this.productManager.sortDownloads(this.account.getDownloads());
        }
        return loginAttempt.getB();
    }

    public void forgetAccount() {
        if (this.hasAccount()) {
            this.account.deleteAccountJson();
            this.productManager.clearProducts();
            this.account = ContinuumAccount.createAdhocAccount();
            this.shaderpackManager.deregisterEncryptedPacks();
        }
    }

    public static FocalEngineCore getInstance() {
        if (instance == null) {
            instance = new FocalEngineCore(null);
        }
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    public ProductManager getProductManager() {
        return this.productManager;
    }

    public Thread getAccountLoadThread() {
        return this.accountLoadThread;
    }

    static {
        GL_DEBUG_GROUPS = false;
    }
}

